/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.device;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapability;
import sonar.fluxnetworks.common.block.FluxConnectorBlock;
import sonar.fluxnetworks.common.device.FluxConnectorHandler;
import sonar.fluxnetworks.common.device.TileFluxDevice;
import sonar.fluxnetworks.common.util.FluxUtils;

public abstract class TileFluxConnector
extends TileFluxDevice {
    protected TileFluxConnector(@Nonnull BlockEntityType<?> type, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        super(type, pos, state);
    }

    @Override
    @Nonnull
    public abstract FluxConnectorHandler getTransferHandler();

    @Nullable
    public abstract <T> T getEnergyCapability(BlockCapability<T, Direction> var1, @Nullable Direction var2);

    @Override
    protected void onFirstTick() {
        super.onFirstTick();
        if (!this.level.isClientSide) {
            int newState = 0;
            for (Direction direction : FluxUtils.DIRECTIONS) {
                BlockEntity target = this.level.getBlockEntity(this.worldPosition.relative(direction));
                newState |= this.getTransferHandler().updateSideTransfer(direction, target, false);
            }
            this.sendBlockUpdateIfNeeded(newState);
        }
    }

    public void updateSideTransfer(@Nonnull Direction side, @Nullable BlockEntity target) {
        int newState = this.getTransferHandler().updateSideTransfer(side, target, true);
        this.sendBlockUpdateIfNeeded(newState);
    }

    private void sendBlockUpdateIfNeeded(int newState) {
        assert (this.level != null && !this.level.isClientSide);
        if ((this.mFlags & 0x3F) != newState) {
            this.mFlags = this.mFlags & 0xFFFFFFC0 | newState;
            this.sendBlockUpdate();
        }
    }

    @Override
    public void sendBlockUpdate() {
        super.sendBlockUpdate();
        assert (this.level != null && !this.level.isClientSide);
        BlockState state = this.getBlockState();
        for (Direction dir : FluxUtils.DIRECTIONS) {
            int index = dir.get3DDataValue();
            state = (BlockState)state.setValue((Property)FluxConnectorBlock.SIDES_CONNECTED[index], (Comparable)Boolean.valueOf((this.mFlags & 1 << index) != 0));
        }
        this.level.setBlock(this.worldPosition, state, 8);
    }
}

