/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.device;

import sonar.fluxnetworks.common.device.FluxConnectorHandler;
import sonar.fluxnetworks.common.device.SideTransfer;

public class FluxPointHandler
extends FluxConnectorHandler {
    private long mDesired;

    @Override
    public void onCycleStart() {
        super.onCycleStart();
        this.mDesired = this.sendToConsumers(this.getLimit(), true);
    }

    @Override
    public void onCycleEnd() {
        this.mChange = -this.sendToConsumers(Math.min(this.mBuffer, this.getLimit()), false);
        this.mBuffer += this.mChange;
    }

    @Override
    public void addToBuffer(long energy) {
        this.mBuffer += energy;
    }

    @Override
    public long getRequest() {
        return Math.max(this.mDesired - this.mBuffer, 0L);
    }

    private long sendToConsumers(long energy, boolean simulate) {
        long leftover = energy;
        for (SideTransfer transfer : this.mTransfers) {
            if (transfer == null || (leftover -= transfer.send(leftover, simulate)) > 0L) continue;
            return energy;
        }
        return energy - leftover;
    }
}

