/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.common.block.FluxConnectorBlock;
import sonar.fluxnetworks.common.device.TileFluxDevice;
import sonar.fluxnetworks.common.device.TileFluxPoint;
import sonar.fluxnetworks.common.util.FluxShapes;
import sonar.fluxnetworks.common.util.FluxUtils;
import sonar.fluxnetworks.register.RegistryBlockEntityTypes;

@ParametersAreNonnullByDefault
public class FluxPointBlock
extends FluxConnectorBlock {
    public FluxPointBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        VoxelShape shape = FluxShapes.FLUX_POINT_CENTRE_VOXEL;
        for (Direction direction : FluxUtils.DIRECTIONS) {
            if (!((Boolean)state.getValue((Property)SIDES_CONNECTED[direction.get3DDataValue()])).booleanValue()) continue;
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)FluxShapes.CONNECTORS_ROTATED_VOXELS[direction.get3DDataValue()]);
        }
        return shape;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(FluxTranslate.FLUX_POINT_TOOLTIP.getComponent());
        super.appendHoverText(stack, context, tooltip, flag);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileFluxPoint(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (type == RegistryBlockEntityTypes.FLUX_POINT.get()) {
            return TileFluxDevice.getTicker(level);
        }
        return null;
    }
}

