/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.log.JMLogger;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.RenderWrapper;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.RegionMipmapGenerator;
import journeymap.common.Journeymap;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.ChunkPos;

public class RegionTexture
extends AbstractTexture {
    protected final ReentrantLock bufferLock = new ReentrantLock();
    protected Set<ChunkPos> dirtyChunks = new HashSet<ChunkPos>();
    protected List<WeakReference<Listener<RegionTexture>>> listeners = new ArrayList<WeakReference<Listener<RegionTexture>>>(0);
    protected long lastImageUpdate;
    protected String description;
    protected boolean bindNeeded;
    protected long lastBound;
    protected NativeImage image;
    protected NativeImage[] mipmaps;
    protected int width;
    protected int height;
    protected final int mipmapLevels;

    public RegionTexture(NativeImage pixels, String description) {
        this.mipmapLevels = JourneymapClient.getInstance().getCoreProperties().mipmapLevels.get();
        this.setNativeImage(pixels, true);
        this.description = description;
        this.mipmaps = RegionMipmapGenerator.generateMipmaps(this.image, this.mipmapLevels);
    }

    public void bind() {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(this::bindRegionTexture);
        } else {
            this.bindRegionTexture();
        }
    }

    public void bindRegionTexture() {
        if (this.bindNeeded && this.bufferLock.tryLock()) {
            try {
                int err;
                if (this.id == -1) {
                    this.id = this.getId();
                }
                super.bind();
                if (this.lastBound == 0L || this.dirtyChunks.isEmpty()) {
                    int i;
                    if (this.mipmaps == null) {
                        this.mipmaps = RegionMipmapGenerator.generateMipmaps(this.image, this.mipmapLevels);
                    }
                    RenderWrapper.texParameter(3553, 10241, 9984);
                    RenderWrapper.texParameter(3553, 10240, 9728);
                    RenderWrapper.texParameter(3553, 10242, 33071);
                    RenderWrapper.texParameter(3553, 10243, 33071);
                    RenderWrapper.texParameter(3553, 33085, this.mipmapLevels);
                    RenderWrapper.texParameter(3553, 33082, 0);
                    RenderWrapper.texParameter(3553, 33083, this.mipmapLevels);
                    RenderWrapper.texParameter(3553, 34049, 0);
                    for (i = 0; i <= this.mipmapLevels; ++i) {
                        RenderWrapper.texImage2D(3553, i, this.image.format().glFormat(), this.mipmaps[i].getWidth(), this.mipmaps[i].getHeight(), 0, 6408, 5121, null);
                    }
                    for (i = 0; i <= this.mipmapLevels; ++i) {
                        NativeImage image = this.mipmaps[i];
                        if (image == null || image.pixels == 0L || this.id() == -1) continue;
                        image.upload(i, 0, 0, 0, 0, image.getWidth(), image.getHeight(), false, false, true, false);
                    }
                    this.bindNeeded = false;
                    this.lastBound = System.currentTimeMillis();
                    return;
                }
                this.uploadDirtyChunks();
                while ((err = RenderWrapper.getError()) != 0) {
                    JMLogger.logOnce("GL Error in RegionTexture after upload: " + err + " in " + String.valueOf((Object)this));
                }
                this.dirtyChunks.clear();
                this.lastBound = System.currentTimeMillis();
                this.bindNeeded = false;
            }
            catch (Throwable t) {
                Journeymap.getLogger().warn("Can't bind texture: ", t);
            }
            finally {
                this.bufferLock.unlock();
            }
        }
    }

    private void uploadDirtyChunks() {
        for (ChunkPos pos : this.dirtyChunks) {
            NativeImage chunkImage = ImageUtil.getSubImage(pos.x, pos.z, 16, 16, this.image, false);
            try {
                if (chunkImage.pixels == 0L) continue;
                chunkImage.copyRect(this.image, 0, 0, pos.x, pos.z, 16, 16, false, false);
                chunkImage.upload(0, pos.x, pos.z, 0, 0, 16, 16, true, true);
            }
            finally {
                if (chunkImage == null) continue;
                chunkImage.close();
            }
        }
        RegionMipmapGenerator.updateMipmapsAndUpload(this.mipmaps, this.dirtyChunks);
    }

    public long getLastImageUpdate() {
        return this.lastImageUpdate;
    }

    public boolean isBound() {
        return this.id != -1;
    }

    public int id() {
        return this.id;
    }

    public boolean isDefunct() {
        return this.image == null && this.id == -1 || this.image != null && this.image.pixels == 0L;
    }

    public void setNativeImage(NativeImage image, boolean retainImage) {
        if (image == null) {
            return;
        }
        this.handleImage(image, retainImage);
        this.lastImageUpdate = System.currentTimeMillis();
        this.notifyListeners();
    }

    public Integer getRGB(int x, int y) {
        int rgba = this.image.getPixelRGBA(x, y);
        return RGB.rgbaToRgb(rgba);
    }

    public void setNativeImage(NativeImage image, boolean retainImage, HashSet<ChunkPos> updatedChunks) {
        if (image == null) {
            return;
        }
        this.handleImage(image, retainImage);
        this.dirtyChunks.addAll(updatedChunks);
        this.lastImageUpdate = System.currentTimeMillis();
        this.notifyListeners();
    }

    private void handleImage(NativeImage image, boolean retainImage) {
        this.bindNeeded = true;
        try {
            this.bufferLock.lock();
            this.width = image.getWidth();
            this.height = image.getHeight();
            if (retainImage) {
                if (this.image == null) {
                    this.image = image;
                } else if (image.pixels != this.image.pixels) {
                    this.image.copyFrom(image);
                }
            }
            if (image.pixels != this.image.pixels) {
                this.clearMipmaps();
                image.close();
            }
        }
        finally {
            this.bufferLock.unlock();
        }
    }

    public void addListener(Listener<RegionTexture> addedListener) {
        Iterator<WeakReference<Listener<RegionTexture>>> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            WeakReference<Listener<RegionTexture>> ref = iter.next();
            Listener listener = (Listener)ref.get();
            if (listener == null) {
                iter.remove();
                continue;
            }
            if (addedListener != listener) continue;
            return;
        }
        this.listeners.add(new WeakReference<Listener<RegionTexture>>(addedListener));
    }

    protected void notifyListeners() {
        Iterator<WeakReference<Listener<RegionTexture>>> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            WeakReference<Listener<RegionTexture>> ref = iter.next();
            Listener listener = (Listener)ref.get();
            if (listener == null) {
                iter.remove();
                continue;
            }
            listener.textureImageUpdated(this);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("glid", this.id).add("description", (Object)this.description).add("lastImageUpdate", this.lastImageUpdate).toString();
    }

    public boolean bindNeeded() {
        return this.bindNeeded;
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public boolean hasImage() {
        return this.image != null && this.image.pixels > 0L;
    }

    private void clearMipmaps() {
        if (this.mipmaps != null) {
            for (int i = 0; i < this.mipmaps.length; ++i) {
                if (this.mipmaps[i] == null) continue;
                this.mipmaps[i].close();
                this.mipmaps[i] = null;
            }
            this.mipmaps = null;
        }
    }

    public void close() {
        this.listeners.forEach(Reference::clear);
        if (this.image != null) {
            this.image.close();
        }
        JMRenderTypes.clearRegionRenderTypes(this.id);
        this.releaseId();
        this.bindNeeded = false;
        this.lastImageUpdate = 0L;
        this.lastBound = 0L;
        this.clearMipmaps();
        this.image = null;
    }

    public NativeImage getNativeImage() {
        return this.image;
    }

    public void load(ResourceManager pResourceManager) {
    }

    public static interface Listener<RegionTexture> {
        public void textureImageUpdated(RegionTexture var1);
    }
}

