/*
 * Decompiled with CFR 0.152.
 */
package journeymap.api.client.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import journeymap.api.services.EventBus;
import journeymap.api.v2.client.event.EntityRegistrationEvent;
import journeymap.api.v2.common.event.ClientEventRegistry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.npc.Villager;

public class EntityRegistrationFactory {
    private EntityRegistrationEvent event;
    private List<Class<? extends Entity>> passives;
    private List<Class<? extends Entity>> hostiles;
    private List<Class<? extends Entity>> villagers;
    private List<Class<? extends Entity>> ambient;
    private List<Class<? extends Entity>> entities;
    private static EntityRegistrationFactory instance;

    public static void init() {
        EntityRegistrationFactory.prepare();
        ClientEventRegistry.ENTITY_REGISTRATION_EVENT.subscribe("journeymap", EntityRegistrationFactory::register);
        EventBus.post(EntityRegistrationFactory.getInstance().event);
    }

    private static void prepare() {
        EntityRegistrationFactory factory = EntityRegistrationFactory.getInstance();
        HashMap entityClasses = new HashMap();
        entityClasses.put(EntityRegistrationEvent.Type.PASSIVE, new ArrayList());
        entityClasses.put(EntityRegistrationEvent.Type.HOSTILE, new ArrayList());
        entityClasses.put(EntityRegistrationEvent.Type.VILLAGER, new ArrayList());
        entityClasses.put(EntityRegistrationEvent.Type.AMBIENT, new ArrayList());
        entityClasses.put(EntityRegistrationEvent.Type.ENTITY, new ArrayList());
        factory.event = new EntityRegistrationEvent(entityClasses);
    }

    private static void register(EntityRegistrationEvent event) {
        event.addHostileEntity(PathfinderMob.class).addVillagerEntity(Villager.class).addPassiveEntity(Animal.class).addPassiveEntity(AbstractGolem.class).addPassiveEntity(WaterAnimal.class).addPassiveEntity(PathfinderMob.class).addAmbientEntity(AmbientCreature.class);
    }

    public static EntityRegistrationFactory getInstance() {
        if (instance == null) {
            instance = new EntityRegistrationFactory();
        }
        return instance;
    }

    public List<Class<? extends Entity>> getPassives() {
        if (this.passives == null) {
            this.passives = this.event.getEntityClasses(EntityRegistrationEvent.Type.PASSIVE);
        }
        return this.passives;
    }

    public List<Class<? extends Entity>> getHostiles() {
        if (this.hostiles == null) {
            this.hostiles = this.event.getEntityClasses(EntityRegistrationEvent.Type.HOSTILE);
        }
        return this.hostiles;
    }

    public List<Class<? extends Entity>> getVillagers() {
        if (this.villagers == null) {
            this.villagers = this.event.getEntityClasses(EntityRegistrationEvent.Type.VILLAGER);
        }
        return this.villagers;
    }

    public List<Class<? extends Entity>> getAmbient() {
        if (this.ambient == null) {
            this.ambient = this.event.getEntityClasses(EntityRegistrationEvent.Type.AMBIENT);
        }
        return this.ambient;
    }

    public List<Class<? extends Entity>> getEntities() {
        if (this.entities == null) {
            this.entities = this.event.getEntityClasses(EntityRegistrationEvent.Type.ENTITY);
        }
        return this.entities;
    }
}

