/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.entity.baby;

import mekanism.additions.common.registries.AdditionsEntityTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class EntityBabyWitherSkeleton
extends WitherSkeleton {
    public EntityBabyWitherSkeleton(EntityType<EntityBabyWitherSkeleton> type, Level world) {
        super(type, world);
        this.xpReward = (int)((double)this.xpReward * 2.5);
        AdditionsEntityTypes.setupBabyModifiers((LivingEntity)this);
    }

    public boolean isBaby() {
        return true;
    }

    @NotNull
    public EntityDimensions getDefaultDimensions(@NotNull Pose pose) {
        return this.getType().getDimensions();
    }

    protected void populateDefaultEquipmentSlots(@NotNull RandomSource random, @NotNull DifficultyInstance difficulty) {
        super.populateDefaultEquipmentSlots(random, difficulty);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
            this.setItemSlot(slot, ItemStack.EMPTY);
        }
    }
}

