/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.config;

import com.hlysine.create_connected.CreateConnected;
import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import net.createmod.catnip.config.ConfigBase;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.configuration.ServerConfigurationPacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.configuration.ICustomConfigurationTask;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public abstract class SyncConfigBase
extends ConfigBase {
    public final CompoundTag getSyncConfig() {
        CompoundTag nbt = new CompoundTag();
        this.writeSyncConfig(nbt);
        if (this.children != null) {
            for (ConfigBase child : this.children) {
                if (!(child instanceof SyncConfigBase)) continue;
                SyncConfigBase syncChild = (SyncConfigBase)child;
                if (nbt.contains(child.getName())) {
                    throw new RuntimeException("A sync config key starts with " + child.getName() + " but does not belong to the child");
                }
                nbt.put(child.getName(), (Tag)syncChild.getSyncConfig());
            }
        }
        return nbt;
    }

    protected void writeSyncConfig(CompoundTag nbt) {
    }

    public final void setSyncConfig(CompoundTag config) {
        if (this.children != null) {
            for (ConfigBase child : this.children) {
                if (!(child instanceof SyncConfigBase)) continue;
                SyncConfigBase syncChild = (SyncConfigBase)child;
                CompoundTag nbt = config.getCompound(child.getName());
                syncChild.readSyncConfig(nbt);
            }
        }
        this.readSyncConfig(config);
    }

    protected void readSyncConfig(CompoundTag nbt) {
    }

    public void onLoad() {
        super.onLoad();
        this.syncToAllPlayers();
    }

    public void onReload() {
        super.onReload();
        this.syncToAllPlayers();
    }

    public void syncToAllPlayers() {
        CatnipServices.PLATFORM.executeOnServerOnly(() -> () -> {
            if (ServerLifecycleHooks.getCurrentServer() == null) {
                return;
            }
            CreateConnected.LOGGER.debug("Sync Config: Sending server config to all players on reload");
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncConfig(this.getSyncConfig()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
    }

    public void syncToPlayer(ServerPlayer player) {
        if (player == null) {
            return;
        }
        CatnipServices.PLATFORM.executeOnServerOnly(() -> () -> {
            CreateConnected.LOGGER.debug("Sync Config: Sending server config to {}", (Object)player.getScoreboardName());
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncConfig(this.getSyncConfig()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
    }

    protected void registerAsSyncRoot(RegisterPayloadHandlersEvent event, String version) {
        PayloadRegistrar registrar = event.registrar(version);
        registrar.configurationToClient(SyncConfig.TYPE, SyncConfig.STREAM_CODEC, this::handleData);
        registrar.playToClient(SyncConfig.TYPE, SyncConfig.STREAM_CODEC, this::handleData);
        NeoForge.EVENT_BUS.addListener(e -> {
            Player patt0$temp = e.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                this.syncToPlayer(serverPlayer);
            }
        });
    }

    public void handleData(SyncConfig data, IPayloadContext context) {
        this.setSyncConfig(data.nbt());
        CreateConnected.LOGGER.debug("Sync Config: Received and applied server config {}", (Object)data.nbt().toString());
    }

    public record SyncConfig(CompoundTag nbt) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SyncConfig> TYPE = new CustomPacketPayload.Type(CreateConnected.asResource("sync_config"));
        public static final StreamCodec<ByteBuf, SyncConfig> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, SyncConfig::nbt, SyncConfig::new);

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public static abstract class SyncConfigTask
    implements ICustomConfigurationTask {
        public static final ConfigurationTask.Type TYPE = new ConfigurationTask.Type(CreateConnected.asResource("sync_config_task"));
        private final ServerConfigurationPacketListener listener;

        public SyncConfigTask(ServerConfigurationPacketListener listener) {
            this.listener = listener;
        }

        protected abstract SyncConfigBase getSyncConfig();

        public void run(Consumer<CustomPacketPayload> sender) {
            SyncConfig payload = new SyncConfig(this.getSyncConfig().getSyncConfig());
            sender.accept(payload);
            this.listener.finishCurrentTask(this.type());
        }

        @NotNull
        public ConfigurationTask.Type type() {
            return TYPE;
        }
    }
}

