/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.block.BalmBlocks;
import net.blay09.mods.waystones.block.PortstoneBlock;
import net.blay09.mods.waystones.block.SharestoneBlock;
import net.blay09.mods.waystones.block.WarpPlateBlock;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.jetbrains.annotations.Nullable;

public class ModBlocks {
    private static final DyeColor[] portstoneColors = new DyeColor[]{DyeColor.WHITE, DyeColor.ORANGE, DyeColor.MAGENTA, DyeColor.LIGHT_BLUE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.PINK, DyeColor.GRAY, DyeColor.LIGHT_GRAY, DyeColor.CYAN, DyeColor.PURPLE, DyeColor.BLUE, DyeColor.BROWN, DyeColor.GREEN, DyeColor.RED, DyeColor.BLACK};
    private static final DyeColor[] sharestoneColors = new DyeColor[]{DyeColor.ORANGE, DyeColor.MAGENTA, DyeColor.LIGHT_BLUE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.PINK, DyeColor.GRAY, DyeColor.LIGHT_GRAY, DyeColor.CYAN, DyeColor.PURPLE, DyeColor.BLUE, DyeColor.BROWN, DyeColor.GREEN, DyeColor.RED, DyeColor.BLACK};
    public static Block waystone;
    public static Block mossyWaystone;
    public static Block sandyWaystone;
    public static Block deepslateWaystone;
    public static Block blackstoneWaystone;
    public static Block endStoneWaystone;
    public static Block warpPlate;
    public static final PortstoneBlock[] portstones;
    public static final SharestoneBlock[] sharestones;

    public static void initialize(BalmBlocks blocks) {
        blocks.register(() -> {
            waystone = new WaystoneBlock(ModBlocks.defaultProperties());
            return waystone;
        }, () -> ModBlocks.itemBlock(waystone), ModBlocks.id("waystone"));
        blocks.register(() -> {
            mossyWaystone = new WaystoneBlock(ModBlocks.defaultProperties());
            return mossyWaystone;
        }, () -> ModBlocks.itemBlock(mossyWaystone), ModBlocks.id("mossy_waystone"));
        blocks.register(() -> {
            sandyWaystone = new WaystoneBlock(ModBlocks.defaultProperties());
            return sandyWaystone;
        }, () -> ModBlocks.itemBlock(sandyWaystone), ModBlocks.id("sandy_waystone"));
        blocks.register(() -> {
            deepslateWaystone = new WaystoneBlock(ModBlocks.defaultProperties().sound(SoundType.DEEPSLATE));
            return deepslateWaystone;
        }, () -> ModBlocks.itemBlock(deepslateWaystone), ModBlocks.id("deepslate_waystone"));
        blocks.register(() -> {
            blackstoneWaystone = new WaystoneBlock(ModBlocks.defaultProperties());
            return blackstoneWaystone;
        }, () -> ModBlocks.itemBlock(blackstoneWaystone), ModBlocks.id("blackstone_waystone"));
        blocks.register(() -> {
            endStoneWaystone = new WaystoneBlock(ModBlocks.defaultProperties());
            return endStoneWaystone;
        }, () -> ModBlocks.itemBlock(endStoneWaystone), ModBlocks.id("end_stone_waystone"));
        blocks.register(() -> {
            warpPlate = new WarpPlateBlock(ModBlocks.defaultProperties());
            return warpPlate;
        }, () -> ModBlocks.itemBlock(warpPlate), ModBlocks.id("warp_plate"));
        for (DyeColor color : portstoneColors) {
            blocks.register(() -> {
                PortstoneBlock portstoneBlock = new PortstoneBlock(color, ModBlocks.defaultProperties());
                ModBlocks.portstones[color.ordinal()] = portstoneBlock;
                return portstoneBlock;
            }, () -> ModBlocks.itemBlock((Block)portstones[color.ordinal()]), ModBlocks.id(color.getSerializedName() + "_portstone"));
        }
        for (DyeColor color : sharestoneColors) {
            blocks.register(() -> {
                SharestoneBlock sharestoneBlock = new SharestoneBlock(color, ModBlocks.defaultProperties());
                ModBlocks.sharestones[color.ordinal() - 1] = sharestoneBlock;
                return sharestoneBlock;
            }, () -> ModBlocks.itemBlock((Block)sharestones[color.ordinal() - 1]), ModBlocks.id(color.getSerializedName() + "_sharestone"));
        }
    }

    private static BlockItem itemBlock(Block block) {
        return new BlockItem(block, Balm.getItems().itemProperties());
    }

    private static ResourceLocation id(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"waystones", (String)name);
    }

    private static BlockBehaviour.Properties defaultProperties() {
        return Balm.getBlocks().blockProperties().sound(SoundType.STONE).strength(5.0f, 2000.0f);
    }

    @Nullable
    public static SharestoneBlock getSharestone(DyeColor color) {
        int index = color.ordinal() - 1;
        if (index < 0 || index >= sharestones.length) {
            return null;
        }
        return sharestones[index];
    }

    @Nullable
    public static PortstoneBlock getPortstone(DyeColor color) {
        int index = color.ordinal();
        if (index >= portstones.length) {
            return null;
        }
        return portstones[index];
    }

    static {
        portstones = new PortstoneBlock[portstoneColors.length];
        sharestones = new SharestoneBlock[sharestoneColors.length];
    }
}

