/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability.mobeffect;

import artifacts.component.ability.EntityCondition;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

public record MobEffectProvider(Holder<MobEffect> mobEffect, Value<Integer> level, Value<Integer> duration, Value<Boolean> spawnParticles, Value<Boolean> showIcon, EntityCondition condition) {
    public static final StreamCodec<RegistryFriendlyByteBuf, MobEffectProvider> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.MOB_EFFECT), MobEffectProvider::mobEffect, ValueTypes.MOB_EFFECT_LEVEL.streamCodec(), MobEffectProvider::level, ValueTypes.DURATION.streamCodec(), MobEffectProvider::duration, ValueTypes.BOOLEAN.streamCodec(), MobEffectProvider::spawnParticles, ValueTypes.BOOLEAN.streamCodec(), MobEffectProvider::showIcon, EntityCondition.STREAM_CODEC, MobEffectProvider::condition, MobEffectProvider::new);

    public static Codec<MobEffectProvider> codec(boolean showParticles) {
        return RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.MOB_EFFECT.holderByNameCodec().fieldOf("id").forGetter(MobEffectProvider::mobEffect), (App)ValueTypes.MOB_EFFECT_LEVEL.codec().optionalFieldOf("level", Value.of(1)).forGetter(MobEffectProvider::level), (App)ValueTypes.DURATION.codec().optionalFieldOf("duration", Value.of(10)).forGetter(MobEffectProvider::duration), (App)ValueTypes.BOOLEAN.codec().optionalFieldOf("spawn_particles", Value.of(showParticles)).forGetter(MobEffectProvider::spawnParticles), (App)ValueTypes.BOOLEAN.codec().optionalFieldOf("show_icon", Value.of(false)).forGetter(MobEffectProvider::showIcon), (App)EntityCondition.CODEC.optionalFieldOf("condition", (Object)EntityCondition.ALWAYS).forGetter(MobEffectProvider::condition)).apply((Applicative)instance, MobEffectProvider::new));
    }

    public int getDuration(int multiplier) {
        return (Integer)this.duration().get() * 20 * multiplier + 19;
    }

    public int getAmplifier() {
        return (Integer)this.level().get() - 1;
    }

    public boolean isNonCosmetic() {
        return (Integer)this.level().get() > 0 && (Integer)this.duration().get() > 0 && this.condition() != EntityCondition.NEVER;
    }

    public boolean canApply(LivingEntity entity) {
        return this.isNonCosmetic() && this.condition.test(entity);
    }

    public MobEffectInstance createEffect() {
        return this.createEffect(1);
    }

    public MobEffectInstance createEffect(int multiplier) {
        return new MobEffectInstance(this.mobEffect(), this.getDuration(multiplier), this.getAmplifier(), false, ((Boolean)this.spawnParticles().get()).booleanValue(), ((Boolean)this.showIcon().get()).booleanValue());
    }
}

