/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability.mobeffect;

import artifacts.component.ability.CompositeAbility;
import artifacts.component.ability.EntityCondition;
import artifacts.component.ability.EquipmentAbility;
import artifacts.component.ability.TickingAbility;
import artifacts.component.ability.TickingCompositeAbility;
import artifacts.component.ability.mobeffect.MobEffectProvider;
import artifacts.config.value.Value;
import artifacts.registry.ModDataComponents;
import artifacts.registry.ModMobEffects;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;

public record EquipmentMobEffects(List<Entry> entries) implements TickingCompositeAbility<Entry>
{
    private static final Set<Holder<MobEffect>> CUSTOM_TOOLTIP_MOB_EFFECTS = Set.of(MobEffects.INVISIBILITY, ModMobEffects.MAGNETISM);
    public static final Codec<EquipmentMobEffects> CODEC = CompositeAbility.codec(Entry.CODEC, EquipmentMobEffects::new, EquipmentMobEffects::entries);
    public static final StreamCodec<RegistryFriendlyByteBuf, EquipmentMobEffects> STREAM_CODEC = CompositeAbility.streamCodec(Entry.STREAM_CODEC, EquipmentMobEffects::new, EquipmentMobEffects::entries);

    public record Entry(MobEffectProvider provider) implements TickingAbility
    {
        public static final Codec<Entry> CODEC = MobEffectProvider.codec(false).xmap(Entry::new, Entry::provider);
        public static final StreamCodec<RegistryFriendlyByteBuf, Entry> STREAM_CODEC = MobEffectProvider.STREAM_CODEC.map(Entry::new, Entry::provider);

        @Override
        public void onUnequip(LivingEntity entity) {
            MobEffectInstance instance = entity.getEffect(this.provider.mobEffect());
            if (instance != null && instance.getAmplifier() == this.provider.getAmplifier() && instance.isVisible() == ((Boolean)this.provider.spawnParticles().get()).booleanValue() && instance.showIcon() == ((Boolean)this.provider.showIcon().get()).booleanValue() && instance.endsWithin(this.provider.getDuration(1) * 20 + 19)) {
                entity.removeEffect(this.provider.mobEffect());
            }
        }

        @Override
        public void wornTick(LivingEntity entity, boolean isOnCooldown, boolean isDisabled) {
            if (!isDisabled && !isOnCooldown && this.provider.canApply(entity)) {
                entity.addEffect(this.provider.createEffect());
            }
        }

        @Override
        public boolean isNonCosmetic() {
            return this.provider().isNonCosmetic();
        }

        @Override
        public void addToTooltip(EquipmentAbility.TooltipWriter writer) {
            if (CUSTOM_TOOLTIP_MOB_EFFECTS.contains(this.provider.mobEffect())) {
                ResourceLocation id = BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)this.provider.mobEffect().value()));
                writer.add(Objects.requireNonNull(id).getPath(), new Object[0]);
            }
            if (this.provider.mobEffect().value() == MobEffects.NIGHT_VISION.value()) {
                Value nightVisionStrength = (Value)writer.stack().get(ModDataComponents.REDUCED_NIGHT_VISION.get());
                if (nightVisionStrength != null && (Double)nightVisionStrength.get() < 0.5) {
                    writer.add("night_vision.partial", new Object[0]);
                } else {
                    writer.add("night_vision.full", new Object[0]);
                }
            }
            if (this.provider.mobEffect().value() == MobEffects.WATER_BREATHING.value()) {
                if (this.provider.condition() == EntityCondition.ALWAYS) {
                    writer.add("water_breathing.infinite", new Object[0]);
                } else {
                    writer.add("water_breathing.limited", new Object[0]);
                }
            }
        }
    }
}

