/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public final class AnimatableIdCache
extends SavedData {
    private static final SavedData.Factory<AnimatableIdCache> FACTORY = new SavedData.Factory(AnimatableIdCache::new, AnimatableIdCache::new, null);
    private static final String DATA_KEY = "geckolib_id_cache";
    private long lastId;

    private AnimatableIdCache() {
    }

    private AnimatableIdCache(CompoundTag tag, HolderLookup.Provider registryLookup) {
        this.lastId = tag.getLong("last_id");
    }

    public static long getFreeId(ServerLevel level) {
        return AnimatableIdCache.getCache(level).getNextId();
    }

    private long getNextId() {
        this.setDirty();
        return ++this.lastId;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registryLookup) {
        tag.putLong("last_id", this.lastId);
        return tag;
    }

    private static AnimatableIdCache getCache(ServerLevel level) {
        return (AnimatableIdCache)level.getServer().overworld().getDataStorage().computeIfAbsent(FACTORY, DATA_KEY);
    }
}

