/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.various.items.variablemodule;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.CompositeStreamCodec;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.control.parameters.Parameter;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.TextAlign;
import mcjty.rftoolscontrol.compat.rftoolssupport.ModuleDataVariable;
import mcjty.rftoolscontrol.modules.processor.ProcessorModule;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.setup.Config;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public record VariableScreenModule(String line, int color, int varColor, TextAlign align, int varIdx, ResourceKey<Level> dim, BlockPos coordinate, String monitorName) implements IScreenModule<VariableScreenModule, ModuleDataVariable>
{
    public static final VariableScreenModule DEFAULT = new VariableScreenModule("", 0xFFFFFF, 0xFFFFFF, TextAlign.ALIGN_LEFT, -1, (ResourceKey<Level>)Level.OVERWORLD, BlockPosTools.INVALID, "");
    public static final Codec<VariableScreenModule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("line").forGetter(VariableScreenModule::line), (App)Codec.INT.fieldOf("color").forGetter(VariableScreenModule::color), (App)Codec.INT.fieldOf("varColor").forGetter(VariableScreenModule::varColor), (App)TextAlign.CODEC.fieldOf("align").forGetter(VariableScreenModule::align), (App)Codec.INT.fieldOf("varIdx").forGetter(VariableScreenModule::varIdx), (App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).fieldOf("dim").forGetter(VariableScreenModule::dim), (App)BlockPos.CODEC.fieldOf("coordinate").forGetter(VariableScreenModule::coordinate), (App)Codec.STRING.fieldOf("monitorName").forGetter(VariableScreenModule::monitorName)).apply((Applicative)instance, VariableScreenModule::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, VariableScreenModule> STREAM_CODEC = CompositeStreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, VariableScreenModule::line, (StreamCodec)ByteBufCodecs.INT, VariableScreenModule::color, (StreamCodec)ByteBufCodecs.INT, VariableScreenModule::varColor, (StreamCodec)TextAlign.STREAM_CODEC, VariableScreenModule::align, (StreamCodec)ByteBufCodecs.INT, VariableScreenModule::varIdx, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), VariableScreenModule::dim, (StreamCodec)BlockPos.STREAM_CODEC, VariableScreenModule::coordinate, (StreamCodec)ByteBufCodecs.STRING_UTF8, VariableScreenModule::monitorName, VariableScreenModule::new);

    public VariableScreenModule withLine(String line) {
        return new VariableScreenModule(line, this.color, this.varColor, this.align, this.varIdx, this.dim, this.coordinate, this.monitorName);
    }

    public VariableScreenModule withColor(int color) {
        return new VariableScreenModule(this.line, color, this.varColor, this.align, this.varIdx, this.dim, this.coordinate, this.monitorName);
    }

    public VariableScreenModule withVarColor(int varColor) {
        return new VariableScreenModule(this.line, this.color, varColor, this.align, this.varIdx, this.dim, this.coordinate, this.monitorName);
    }

    public VariableScreenModule withAlign(TextAlign align) {
        return new VariableScreenModule(this.line, this.color, this.varColor, align, this.varIdx, this.dim, this.coordinate, this.monitorName);
    }

    public VariableScreenModule withVarIdx(int varIdx) {
        int clamped = Math.max(-1, Math.min(31, varIdx));
        return new VariableScreenModule(this.line, this.color, this.varColor, this.align, clamped, this.dim, this.coordinate, this.monitorName);
    }

    public VariableScreenModule withDim(ResourceKey<Level> dim) {
        return new VariableScreenModule(this.line, this.color, this.varColor, this.align, this.varIdx, dim, this.coordinate, this.monitorName);
    }

    public VariableScreenModule withCoordinate(BlockPos coordinate) {
        return new VariableScreenModule(this.line, this.color, this.varColor, this.align, this.varIdx, this.dim, coordinate, this.monitorName);
    }

    public VariableScreenModule withMonitorName(String monitorName) {
        return new VariableScreenModule(this.line, this.color, this.varColor, this.align, this.varIdx, this.dim, this.coordinate, monitorName);
    }

    public VariableScreenModule withTarget(ResourceKey<Level> targetDim, BlockPos targetCoordinate, String name) {
        return new VariableScreenModule(this.line, this.color, this.varColor, this.align, this.varIdx, targetDim, targetCoordinate, name);
    }

    public VariableScreenModule clearTarget() {
        return new VariableScreenModule(this.line, this.color, this.varColor, this.align, this.varIdx, this.dim, BlockPosTools.INVALID, "");
    }

    public ModuleDataVariable getData(IScreenDataHelper h, Level worldObj, long millis) {
        ServerLevel world = LevelTools.getLevel((Level)worldObj, this.dim);
        if (world == null) {
            return null;
        }
        if (!BlockPosTools.isValid((BlockPos)this.coordinate) || !LevelTools.isLoaded((Level)world, (BlockPos)this.coordinate)) {
            return null;
        }
        Block block = world.getBlockState(this.coordinate).getBlock();
        if (block != ProcessorModule.PROCESSOR.block().get()) {
            return null;
        }
        if (this.varIdx < 0 || this.varIdx >= 32) {
            return null;
        }
        BlockEntity te = world.getBlockEntity(this.coordinate);
        if (te instanceof ProcessorTileEntity) {
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            Parameter parameter = processor.getVariableAt(this.varIdx);
            return new ModuleDataVariable(parameter);
        }
        return null;
    }

    public int getRfPerTick() {
        return (Integer)Config.VARIABLEMODULE_RFPERTICK.get();
    }

    public VariableScreenModule validate(Level world, BlockPos pos, boolean isPlus) {
        if (!Objects.equals(world.dimension(), this.dim)) {
            return this.withDim((ResourceKey<Level>)world.dimension()).clearTarget();
        }
        if (!BlockPosTools.isValid((BlockPos)this.coordinate)) {
            return this;
        }
        int dx = Math.abs(this.coordinate.getX() - pos.getX());
        int dy = Math.abs(this.coordinate.getY() - pos.getY());
        int dz = Math.abs(this.coordinate.getZ() - pos.getZ());
        if (dx <= 64 && dy <= 64 && dz <= 64) {
            return this;
        }
        return this.clearTarget();
    }

    @NotNull
    public ItemStack mouseClick(ItemStack moduleStack, Level world, int x, int y, boolean clicked, Player player) {
        if (!BlockPosTools.isValid((BlockPos)this.coordinate)) {
            if (player != null) {
                player.displayClientMessage((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.RED) + "Module is not linked to a processor!")), false);
            }
            return moduleStack;
        }
        return moduleStack;
    }
}

