/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.various.items.variablemodule;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.ModuleTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.TextAlign;
import mcjty.rftoolsbase.tools.GenericModuleItem;
import mcjty.rftoolscontrol.RFToolsControl;
import mcjty.rftoolscontrol.modules.processor.ProcessorModule;
import mcjty.rftoolscontrol.modules.various.VariousModule;
import mcjty.rftoolscontrol.modules.various.items.variablemodule.VariableClientScreenModule;
import mcjty.rftoolscontrol.modules.various.items.variablemodule.VariableScreenModule;
import mcjty.rftoolscontrol.setup.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class VariableModuleItem
extends GenericModuleItem {
    public VariableModuleItem() {
        super(RFToolsControl.setup.defaultProperties().stacksTo(1).durability(1));
    }

    @Nullable
    public Codec<? extends IScreenModule<?, ?>> codec() {
        return VariableScreenModule.CODEC;
    }

    @Nullable
    public StreamCodec<RegistryFriendlyByteBuf, ? extends IScreenModule<?, ?>> streamCodec() {
        return VariableScreenModule.STREAM_CODEC;
    }

    @Nullable
    public DataComponentType<? extends IScreenModule<?, ?>> componentType() {
        return (DataComponentType)VariousModule.VARIABLE_MODULE_DATA.get();
    }

    public IScreenModule<?, ?> createServerScreenModule() {
        return VariableScreenModule.DEFAULT;
    }

    public IClientScreenModule<?> createClientScreenModule() {
        return new VariableClientScreenModule();
    }

    protected int getUses(ItemStack stack) {
        return (Integer)Config.VARIABLEMODULE_RFPERTICK.get();
    }

    protected boolean hasGoldMessage(ItemStack stack) {
        return !ModuleTools.hasModuleTarget((ItemStack)stack);
    }

    protected String getInfoString(ItemStack stack) {
        return ModuleTools.getTargetString((ItemStack)stack);
    }

    public String getModuleName() {
        return "VAR";
    }

    public void createGui(IModuleGuiBuilder guiBuilder) {
        guiBuilder.label("Label:").text((stack, s) -> VariableModuleItem.data(stack, module -> module.withLine((String)s)), stack -> VariableModuleItem.data(stack).line(), new String[]{"Label text"}).color((stack, c) -> VariableModuleItem.data(stack, module -> module.withColor((int)c)), stack -> VariableModuleItem.data(stack).color(), new String[]{"Label color"}).nl().label("Stats:").color((stack, c) -> VariableModuleItem.data(stack, module -> module.withVarColor((int)c)), stack -> VariableModuleItem.data(stack).varColor(), new String[]{"Color for the variable text"}).nl().label("Var:").integer((stack, v) -> VariableModuleItem.data(stack, module -> module.withVarIdx(v == null ? -1 : v)), stack -> VariableModuleItem.data(stack).varIdx(), new String[]{"Index of the variable"}).nl().choices((stack, choice) -> VariableModuleItem.data(stack, module -> module.withAlign(TextAlign.get((String)choice))), stack -> VariableModuleItem.data(stack).align().getSerializedName(), "Label alignment", new String[]{"Left", "Center", "Right"}).nl().block(stack -> GlobalPos.of(VariableModuleItem.data(stack).dim(), (BlockPos)VariableModuleItem.data(stack).coordinate()), stack -> VariableModuleItem.data(stack).monitorName()).nl();
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        ItemStack stack = player.getItemInHand(hand);
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (block == ProcessorModule.PROCESSOR.block().get()) {
            String name = Tools.getReadableName((Level)world, (BlockPos)pos);
            VariableModuleItem.data(stack, module -> module.withTarget((ResourceKey<Level>)world.dimension(), pos, name));
            ModuleTools.setPositionInModule((ItemStack)stack, (ResourceKey)world.dimension(), (BlockPos)pos, (String)name);
            if (world.isClientSide) {
                Logging.message((Player)player, (String)"Variable module is set to block");
            }
        } else {
            VariableModuleItem.data(stack, module -> module.clearTarget());
            ModuleTools.clearPositionInModule((ItemStack)stack);
            if (world.isClientSide) {
                Logging.message((Player)player, (String)"Variable module is cleared");
            }
        }
        return InteractionResult.SUCCESS;
    }

    public static VariableScreenModule data(ItemStack stack) {
        VariableScreenModule data = (VariableScreenModule)stack.get(VariousModule.VARIABLE_MODULE_DATA);
        if (data == null) {
            data = VariableScreenModule.DEFAULT;
        }
        return data;
    }

    public static void data(ItemStack stack, Function<VariableScreenModule, VariableScreenModule> setter) {
        VariableScreenModule data = VariableModuleItem.data(stack);
        data = setter.apply(data);
        stack.set((DataComponentType)VariousModule.VARIABLE_MODULE_DATA.get(), (Object)data);
    }
}

