/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic.running;

import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.logic.running.ProgException;
import mcjty.rftoolscontrol.modules.processor.logic.running.RunningProgram;
import mcjty.rftoolscontrol.setup.Config;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;

public class CpuCore {
    private RunningProgram program = null;
    private int tier;
    private boolean debug = false;

    public void setTier(int tier) {
        this.tier = tier;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void run(ProcessorTileEntity processor) {
        if (this.debug) {
            return;
        }
        for (int i = 0; i < (Integer)Config.coreSpeed[this.tier].get(); ++i) {
            boolean rc = false;
            try {
                rc = this.program.run(processor);
            }
            catch (ProgException e) {
                processor.exception(e.getExceptionType(), this.program);
                this.program.killMe();
            }
            if (this.program.isDead()) {
                this.stopProgram(processor);
                return;
            }
            if (rc) continue;
            return;
        }
    }

    public void step(ProcessorTileEntity processor, CpuCore core) {
        try {
            this.program.run(processor);
        }
        catch (ProgException e) {
            processor.exception(e.getExceptionType(), this.program);
            this.program.killMe();
        }
        if (this.program.isDead()) {
            this.stopProgram(processor);
        }
    }

    public int getTier() {
        return this.tier;
    }

    public boolean hasProgram() {
        return this.program != null;
    }

    public RunningProgram getProgram() {
        return this.program;
    }

    public void stopProgram() {
        this.program = null;
    }

    private void stopProgram(ProcessorTileEntity processor) {
        if (RunningProgram.DEBUG) {
            System.out.println("Core: stopping program");
        }
        processor.clearRunningEvent(this.program.getCardIndex(), this.program.getEventIndex());
        this.program = null;
    }

    public void startProgram(RunningProgram program) {
        if (RunningProgram.DEBUG) {
            System.out.println("Core: starting program = " + String.valueOf(program));
        }
        this.program = program;
        program.setCore(this);
    }

    public CompoundTag writeToNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        if (this.program != null) {
            this.program.writeToNBT(tag, provider);
        }
        tag.putInt("tier", this.tier);
        tag.putBoolean("debug", this.debug);
        return tag;
    }

    public void readFromNBT(CompoundTag tag, HolderLookup.Provider provider) {
        this.program = RunningProgram.readFromNBT(tag, provider);
        if (this.program != null) {
            this.program.setCore(this);
        }
        this.tier = tag.getInt("tier");
        this.debug = tag.getBoolean("debug");
    }
}

