/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.craftingstation.client;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.GuiPopupTools;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.events.BlockRenderEvent;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.network.Networking;
import mcjty.lib.network.PacketGetListFromServer;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolscontrol.modules.craftingstation.CraftingStationModule;
import mcjty.rftoolscontrol.modules.craftingstation.blocks.CraftingStationTileEntity;
import mcjty.rftoolscontrol.modules.craftingstation.util.CraftingRequest;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

public class GuiCraftingStation
extends GenericGuiContainer<CraftingStationTileEntity, GenericContainer> {
    public static final int WIDTH = 231;
    public static final int HEIGHT = 236;
    private static final ResourceLocation mainBackground = ResourceLocation.fromNamespaceAndPath((String)"rftoolscontrol", (String)"textures/gui/craftingstation.png");
    private WidgetList recipeList;
    private WidgetList requestList;
    private TextField searchField;
    private Button cancelButton;
    private static List<ItemStack> fromServer_craftables = new ArrayList<ItemStack>();
    private static List<CraftingRequest> fromServer_requests = new ArrayList<CraftingRequest>();
    private int listDirty = 0;

    public static void storeCraftableForClient(List<ItemStack> items) {
        fromServer_craftables = new ArrayList<ItemStack>(items);
    }

    public static void storeRequestsForClient(List<CraftingRequest> requests) {
        fromServer_requests = new ArrayList<CraftingRequest>(requests);
    }

    public GuiCraftingStation(GenericContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title, ManualEntry.EMPTY);
        this.imageWidth = 231;
        this.imageHeight = 236;
    }

    public static void register(RegisterMenuScreensEvent event) {
        event.register(CraftingStationModule.CRAFTING_STATION_CONTAINER.get(), GuiCraftingStation::new);
    }

    public void init() {
        super.init();
        Panel toplevel = (Panel)Widgets.positional().background(mainBackground);
        this.initRecipeList(toplevel);
        this.initProgressList(toplevel);
        this.initButtons(toplevel);
        toplevel.bounds(this.leftPos, this.topPos, 231, 236);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        this.window.event("cancel", (source, params) -> this.cancelRequest());
    }

    private void initButtons(Panel toplevel) {
        this.searchField = Widgets.textfield((int)5, (int)5, (int)175, (int)16);
        this.cancelButton = (Button)((Button)Widgets.button((int)180, (int)5, (int)46, (int)16, (String)"Cancel").channel("cancel")).tooltips(new String[]{String.valueOf(ChatFormatting.YELLOW) + "Cancel request", "Cancel the currently selected", "crafting request"});
        toplevel.children(new Widget[]{this.cancelButton, this.searchField});
    }

    private void cancelRequest() {
        int selected = this.requestList.getSelected();
        if (selected == -1) {
            return;
        }
        this.sendServerCommandTyped(CraftingStationTileEntity.CMD_CANCEL, TypedMap.builder().put(CraftingStationTileEntity.PARAM_INDEX, (Object)selected).build());
    }

    private void initRecipeList(Panel toplevel) {
        this.recipeList = ((WidgetList)Widgets.list((int)5, (int)23, (int)120, (int)128).name("recipes")).propagateEventsToChildren(true).invisibleSelection(true);
        Slider slider = Widgets.slider((int)126, (int)23, (int)9, (int)128).scrollableName("recipes");
        toplevel.children(new Widget[]{this.recipeList, slider});
    }

    private void initProgressList(Panel toplevel) {
        this.requestList = (WidgetList)Widgets.list((int)136, (int)23, (int)80, (int)128).name("requests");
        Slider slider = Widgets.slider((int)217, (int)23, (int)9, (int)128).scrollableName("requests");
        toplevel.children(new Widget[]{this.requestList, slider});
    }

    private void requestLists() {
        GenericTileEntity be = this.getBE();
        Networking.sendToServer((CustomPacketPayload)PacketGetListFromServer.create((BlockPos)be.getBlockPos(), (String)CraftingStationTileEntity.CMD_GETCRAFTABLE.name()));
        Networking.sendToServer((CustomPacketPayload)PacketGetListFromServer.create((BlockPos)be.getBlockPos(), (String)CraftingStationTileEntity.CMD_GETREQUESTS.name()));
    }

    private void requestListsIfNeeded() {
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.requestLists();
            this.listDirty = 10;
        }
    }

    private void updateRequestList() {
        this.requestList.removeChildren();
        for (CraftingRequest request : fromServer_requests) {
            boolean ok;
            ItemStack stack = request.getStack();
            Panel panel = (Panel)Widgets.horizontal().desiredWidth(16);
            this.requestList.children(new Widget[]{panel});
            BlockRender blockRender = new BlockRender().renderItem((Object)stack).offsetX(-1).offsetY(-1);
            panel.children(new Widget[]{blockRender});
            boolean failed = request.getFailed() != -1L;
            boolean bl = ok = request.getOk() != -1L;
            if (failed) {
                panel.children(new Widget[]{Widgets.label((String)"Failed!").color(-53200)});
                continue;
            }
            panel.children(new Widget[]{Widgets.label((String)(ok ? "Ok" : "Wait (" + request.getTodo() + ")")).color(ok ? -13566160 : StyleConfig.colorTextNormal)});
        }
    }

    protected List<Component> addCustomLines(List<Component> oldList, BlockRender blockRender, ItemStack stack) {
        if (blockRender.getUserObject() instanceof Integer) {
            ArrayList<Component> newlist = new ArrayList<Component>();
            newlist.add((Component)ComponentFactory.literal((String)"Click: ").withStyle(ChatFormatting.GREEN).append((Component)ComponentFactory.literal((String)"craft single").withStyle(ChatFormatting.WHITE)));
            newlist.add((Component)ComponentFactory.literal((String)"Shift + click: ").withStyle(ChatFormatting.GREEN).append((Component)ComponentFactory.literal((String)"craft amount").withStyle(ChatFormatting.WHITE)));
            newlist.add((Component)ComponentFactory.literal((String)""));
            newlist.addAll(oldList);
            return newlist;
        }
        return oldList;
    }

    private void updateRecipeList() {
        String filterText = this.searchField.getText().toLowerCase().trim();
        fromServer_craftables.sort(Comparator.comparing(r -> r.getHoverName().getString()));
        this.recipeList.removeChildren();
        Panel panel = null;
        int index = 0;
        for (final ItemStack stack : fromServer_craftables) {
            String displayName = stack.getHoverName().getString();
            if (!filterText.isEmpty() && !displayName.toLowerCase().contains(filterText)) continue;
            if (panel == null || panel.getChildCount() >= 6) {
                panel = (Panel)Widgets.horizontal((int)1, (int)3).desiredHeight(16);
                this.recipeList.children(new Widget[]{panel});
            }
            final BlockRender blockRender = (BlockRender)new BlockRender().renderItem((Object)stack).hilightOnHover(true).offsetX(-1).offsetY(-1).userObject((Object)index);
            ++index;
            blockRender.event(new BlockRenderEvent(){

                public void select() {
                    Object item = blockRender.getRenderItem();
                    if (item != null) {
                        boolean shift = SafeClientTools.isSneaking();
                        Object index = blockRender.getUserObject();
                        if (shift) {
                            GuiCraftingStation.this.askAmountToCraft(stack);
                        } else {
                            GuiCraftingStation.this.requestItem(stack, 1);
                        }
                    }
                }

                public void doubleClick() {
                }
            });
            panel.children(new Widget[]{blockRender});
        }
    }

    private Integer safeParse(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void askAmountToCraft(ItemStack stack) {
        GuiPopupTools.askSomething((Minecraft)this.minecraft, (Screen)this, (WindowManager)this.getWindowManager(), (int)220, (int)50, (String)"Craft amount:", (String)"", s -> {
            Integer a = this.safeParse((String)s);
            if (a != null) {
                this.requestItem(stack, a);
            }
        });
    }

    private void requestItem(ItemStack stack, int amount) {
        this.sendServerCommandTyped(CraftingStationTileEntity.CMD_REQUEST, TypedMap.builder().put(CraftingStationTileEntity.PARAM_ITEM, (Object)stack).put(CraftingStationTileEntity.PARAM_AMOUNT, (Object)amount).build());
    }

    protected void renderBg(@Nonnull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        this.requestListsIfNeeded();
        this.updateRecipeList();
        this.updateRequestList();
        if (this.requestList.getSelected() >= this.requestList.getChildCount()) {
            this.requestList.selected(-1);
        }
        this.cancelButton.enabled(this.requestList.getSelected() != -1);
        this.drawWindow(graphics, partialTicks, mouseX, mouseY);
    }
}

