/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.widget.MutableWidgetRenderContext;
import com.supermartijn642.core.gui.widget.Widget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class WidgetScreen<T extends Widget>
extends Screen {
    private final MutableWidgetRenderContext widgetRenderContext = MutableWidgetRenderContext.create();
    protected final T widget;
    private boolean initialized = false;
    private boolean isPauseScreen = false;

    public static <T extends Widget> WidgetScreen<T> of(T widget) {
        return new WidgetScreen<T>(widget);
    }

    public static <T extends Widget> WidgetScreen<T> of(T widget, boolean isPauseScreen) {
        return new WidgetScreen<T>(widget, isPauseScreen);
    }

    public WidgetScreen(T widget, boolean isPauseScreen) {
        super((Component)TextComponents.empty().get());
        this.widget = widget;
        this.isPauseScreen = isPauseScreen;
    }

    public WidgetScreen(T widget) {
        this(widget, false);
    }

    protected void init() {
        if (!this.initialized) {
            this.widget.initialize();
            this.initialized = true;
        }
    }

    public void onClose() {
        this.widget.discard();
        super.onClose();
    }

    public void tick() {
        this.widget.update();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.widgetRenderContext.update(guiGraphics, partialTicks);
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        int offsetX = (this.width - this.widget.width()) / 2;
        int offsetY = (this.height - this.widget.height()) / 2;
        mouseX -= offsetX;
        mouseY -= offsetY;
        RenderSystem.getModelViewStack().pushMatrix();
        RenderSystem.getModelViewStack().translate((float)offsetX, (float)offsetY, 0.0f);
        RenderSystem.applyModelViewMatrix();
        this.widget.setFocused(mouseX >= 0 && mouseX < this.widget.width() && mouseY >= 0 && mouseY < this.widget.height());
        this.widget.renderBackground(this.widgetRenderContext, mouseX, mouseY);
        this.widget.render(this.widgetRenderContext, mouseX, mouseY);
        this.widget.renderForeground(this.widgetRenderContext, mouseX, mouseY);
        this.widget.renderOverlay(this.widgetRenderContext, mouseX, mouseY);
        this.widget.renderTooltips(this.widgetRenderContext, mouseX, mouseY);
        RenderSystem.getModelViewStack().popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int offsetY;
        int offsetX = (this.width - this.widget.width()) / 2;
        return this.widget.mousePressed((int)(mouseX -= (double)offsetX), (int)(mouseY -= (double)(offsetY = (this.height - this.widget.height()) / 2)), button, false) || super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        int offsetY;
        int offsetX = (this.width - this.widget.width()) / 2;
        return this.widget.mouseReleased((int)(mouseX -= (double)offsetX), (int)(mouseY -= (double)(offsetY = (this.height - this.widget.height()) / 2)), button, false) || super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int offsetY;
        int offsetX = (this.width - this.widget.width()) / 2;
        return this.widget.mouseScrolled((int)(mouseX -= (double)offsetX), (int)(mouseY -= (double)(offsetY = (this.height - this.widget.height()) / 2)), horizontalAmount, false) || super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.widget.keyPressed(keyCode, false)) {
            return true;
        }
        InputConstants.Key key = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (ClientUtils.getMinecraft().options.keyInventory.isActiveAndMatches(key)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return this.widget.keyReleased(keyCode, false) || super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char character, int modifiers) {
        return this.widget.charTyped(character, false) || super.charTyped(character, modifiers);
    }

    public boolean isPauseScreen() {
        return this.isPauseScreen;
    }

    public Component getNarrationMessage() {
        Component message = this.widget.getNarrationMessage();
        return message == null ? TextComponents.empty().get() : message;
    }
}

