/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.navigation;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.neoforged.neoforge.fluids.FluidType;
import net.tslat.smartbrainlib.api.core.navigation.MultiFluidNavigationElement;
import net.tslat.smartbrainlib.api.core.navigation.SmoothGroundNavigation;
import net.tslat.smartbrainlib.api.core.navigation.nodeevaluator.MultiFluidWalkNodeEvaluator;

public class MultiFluidSmoothGroundNavigation
extends SmoothGroundNavigation
implements MultiFluidNavigationElement {
    public MultiFluidSmoothGroundNavigation(Mob mob, Level level) {
        super(mob, level);
    }

    @Override
    protected PathFinder createPathFinder(int maxVisitedNodes) {
        this.nodeEvaluator = new MultiFluidWalkNodeEvaluator();
        this.nodeEvaluator.setCanPassDoors(true);
        return this.createSmoothPathFinder(this.nodeEvaluator, maxVisitedNodes);
    }

    protected boolean canUpdatePath() {
        return this.mob.onGround() || this.mob.isInFluidType((fluidType, height) -> this.canSwimInFluid(this.mob, (FluidType)fluidType, (double)height), true) || this.mob.isPassenger();
    }

    @Override
    public int getSurfaceY() {
        if (this.mob.isInFluidType((fluidType, height) -> this.canSwimInFluid(this.mob, (FluidType)fluidType, (double)height), true) && this.canFloat()) {
            int basePos = this.mob.getBlockY();
            BlockPos.MutableBlockPos pos = BlockPos.containing((double)this.mob.getX(), (double)basePos, (double)this.mob.getZ()).mutable();
            BlockState state = this.level.getBlockState((BlockPos)pos);
            FluidState fluidState = state.getFluidState();
            while (this.canSwimInFluid(this.mob, fluidState.getFluidType(), fluidState.getHeight((BlockGetter)this.level, (BlockPos)pos))) {
                state = this.level.getBlockState((BlockPos)pos.move(Direction.UP));
                fluidState = state.getFluidState();
                if (pos.getY() - basePos <= 16) continue;
                return basePos;
            }
            return pos.getY();
        }
        return Mth.floor((double)(this.mob.getY() + 0.5));
    }
}

