/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.elevator;

import me.desht.pneumaticcraft.common.block.ElevatorCallerBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.CamouflageableBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class ElevatorCallerBlockEntity
extends AbstractTickingBlockEntity
implements CamouflageableBlockEntity,
IRedstoneControl<ElevatorCallerBlockEntity> {
    private ElevatorButton[] floors = new ElevatorButton[0];
    private int thisFloor;
    private boolean emittingRedstone;
    private boolean shouldUpdateNeighbors;
    private BlockState camoState;
    private final RedstoneController<ElevatorCallerBlockEntity> rsController = new RedstoneController<ElevatorCallerBlockEntity>(this);

    public ElevatorCallerBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.ELEVATOR_CALLER.get(), pos, state);
    }

    public void setEmittingRedstone(boolean emittingRedstone) {
        if (emittingRedstone != this.emittingRedstone) {
            this.emittingRedstone = emittingRedstone;
            this.shouldUpdateNeighbors = true;
        }
    }

    @Override
    public boolean hasItemCapability() {
        return false;
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        if (this.shouldUpdateNeighbors) {
            this.updateNeighbours();
            this.shouldUpdateNeighbors = false;
        }
    }

    public boolean getEmittingRedstone() {
        return this.emittingRedstone;
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.emittingRedstone = tag.getBoolean("emittingRedstone");
        this.thisFloor = tag.getInt("thisFloor");
        this.shouldUpdateNeighbors = tag.getBoolean("shouldUpdateNeighbors");
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putBoolean("emittingRedstone", this.emittingRedstone);
        tag.putInt("thisFloor", this.thisFloor);
        tag.putBoolean("shouldUpdateNeighbors", this.shouldUpdateNeighbors);
    }

    @Override
    public void readFromPacket(CompoundTag tag, HolderLookup.Provider provider) {
        super.readFromPacket(tag, provider);
        int floorAmount = tag.getInt("floors");
        this.floors = new ElevatorButton[floorAmount];
        for (int i = 0; i < floorAmount; ++i) {
            this.floors[i] = new ElevatorButton(tag.getCompound("floor" + i));
        }
        this.camoState = CamouflageableBlockEntity.readCamo(tag);
    }

    @Override
    public void writeToPacket(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeToPacket(tag, provider);
        tag.putInt("floors", this.floors.length);
        for (ElevatorButton floor : this.floors) {
            tag.put("floor" + floor.floorNumber, (Tag)floor.writeToNBT(new CompoundTag()));
        }
        CamouflageableBlockEntity.writeCamo(tag, this.camoState);
    }

    @Override
    public void onNeighborBlockUpdate(BlockPos fromPos) {
        boolean wasPowered = this.getRedstoneController().getCurrentRedstonePower() > 0;
        super.onNeighborBlockUpdate(fromPos);
        if (this.getRedstoneController().getCurrentRedstonePower() > 0 && !wasPowered) {
            ElevatorCallerBlock.setSurroundingElevators(this.getLevel(), this.getBlockPos(), this.thisFloor);
        }
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return null;
    }

    void setFloors(ElevatorButton[] floors, int thisFloorLevel) {
        this.floors = floors;
        this.thisFloor = thisFloorLevel;
        this.sendDescriptionPacket();
    }

    public ElevatorButton[] getFloors() {
        return this.floors;
    }

    @Override
    public BlockState getCamouflage() {
        return this.camoState;
    }

    @Override
    public void setCamouflage(BlockState state) {
        this.camoState = state;
        CamouflageableBlockEntity.onCamouflageChanged(this);
    }

    @Override
    public RedstoneController<ElevatorCallerBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    public static class ElevatorButton {
        public final float posX;
        public final float posY;
        public final float width;
        public final float height;
        public final int floorNumber;
        public final int floorHeight;
        public float red;
        public float green;
        public float blue;
        public String buttonText;

        ElevatorButton(float posX, float posY, float width, float height, int floorNumber, int floorHeight) {
            this.posX = posX;
            this.posY = posY;
            this.width = width;
            this.height = height;
            this.floorNumber = floorNumber;
            this.floorHeight = floorHeight;
            this.buttonText = "" + (floorNumber + 1);
        }

        ElevatorButton(CompoundTag tag) {
            this.posX = tag.getFloat("posX");
            this.posY = tag.getFloat("posY");
            this.width = tag.getFloat("width");
            this.height = tag.getFloat("height");
            this.buttonText = tag.getString("buttonText");
            this.floorNumber = tag.getInt("floorNumber");
            this.floorHeight = tag.getInt("floorHeight");
            this.red = tag.getFloat("red");
            this.green = tag.getFloat("green");
            this.blue = tag.getFloat("blue");
        }

        void setColor(float red, float green, float blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public CompoundTag writeToNBT(CompoundTag tag) {
            tag.putFloat("posX", this.posX);
            tag.putFloat("posY", this.posY);
            tag.putFloat("width", this.width);
            tag.putFloat("height", this.height);
            tag.putString("buttonText", this.buttonText);
            tag.putInt("floorNumber", this.floorNumber);
            tag.putInt("floorHeight", this.floorHeight);
            tag.putFloat("red", this.red);
            tag.putFloat("green", this.green);
            tag.putFloat("blue", this.blue);
            return tag;
        }
    }
}

