/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.me;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.inventories.InternalInventory;
import appeng.api.inventories.ItemTransfer;
import appeng.api.networking.IGrid;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.KeyCounter;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.crafting.IMolecularAssemblerSupportedPattern;
import appeng.core.AELog;
import appeng.me.helpers.IGridConnectedBlockEntity;
import appeng.menu.AutoCraftingMenu;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.IAEItemFilter;
import com.glodblock.github.extendedae.ExtendedAE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftingThread {
    @NotNull
    private final AEBaseBlockEntity host;
    protected final IGridConnectedBlockEntity girdHost;
    protected final AppEngInternalInventory gridInv;
    private final InternalInventory gridInvExt;
    private final CraftingContainer craftingInv;
    private Direction pushDirection = null;
    private ItemStack myPattern = ItemStack.EMPTY;
    private IMolecularAssemblerSupportedPattern myPlan = null;
    private double progress = 0.0;
    private boolean isAwake = false;
    protected boolean forcePlan = false;
    private boolean reboot = true;
    private ItemStack output = ItemStack.EMPTY;

    public CraftingThread(@NotNull AEBaseBlockEntity host) {
        if (!(host instanceof InternalInventoryHost)) {
            throw new IllegalArgumentException("Host isn't InternalInventoryHost.");
        }
        if (!(host instanceof IGridConnectedBlockEntity)) {
            throw new IllegalArgumentException("Host isn't IGridConnectedBlockEntity.");
        }
        this.host = host;
        this.girdHost = (IGridConnectedBlockEntity)host;
        this.gridInv = new AppEngInternalInventory((InternalInventoryHost)this.host, 10, 1);
        this.gridInvExt = new FilteredInternalInventory((InternalInventory)this.gridInv, (IAEItemFilter)new CraftingGridFilter());
        this.craftingInv = new TransientCraftingContainer((AbstractContainerMenu)new AutoCraftingMenu(), 3, 3);
    }

    public boolean isAwake() {
        return this.isAwake;
    }

    public boolean acceptJob(IPatternDetails patternDetails, KeyCounter[] table, Direction where) {
        if (this.myPattern.isEmpty() && this.gridInv.isEmpty() && patternDetails instanceof IMolecularAssemblerSupportedPattern) {
            IMolecularAssemblerSupportedPattern pattern = (IMolecularAssemblerSupportedPattern)patternDetails;
            this.forcePlan = true;
            this.myPlan = pattern;
            this.pushDirection = where;
            this.fillGrid(table, pattern);
            this.updateSleepiness();
            this.saveChanges();
            return true;
        }
        return false;
    }

    public void stop() {
        this.myPlan = null;
        this.myPattern = ItemStack.EMPTY;
        this.progress = 0.0;
        this.ejectHeldItems();
        this.updateSleepiness();
    }

    public CompoundTag writeNBT(HolderLookup.Provider register) {
        CompoundTag data = new CompoundTag();
        if (this.forcePlan) {
            ItemStack pattern;
            ItemStack itemStack = pattern = this.myPlan != null ? this.myPlan.getDefinition().toStack() : this.myPattern;
            if (!pattern.isEmpty()) {
                CompoundTag compound = new CompoundTag();
                pattern.save(register, (Tag)compound);
                data.put("myPlan", (Tag)compound);
                data.putInt("pushDirection", this.pushDirection.ordinal());
            }
        }
        return data;
    }

    public void readNBT(CompoundTag data, HolderLookup.Provider register) {
        ItemStack pattern;
        this.forcePlan = false;
        this.myPattern = ItemStack.EMPTY;
        this.myPlan = null;
        if (data.contains("myPlan") && !(pattern = ItemStack.parseOptional((HolderLookup.Provider)register, (CompoundTag)data.getCompound("myPlan"))).isEmpty()) {
            this.forcePlan = true;
            this.myPattern = pattern;
            this.pushDirection = Direction.values()[data.getInt("pushDirection")];
        }
        this.recalculatePlan();
    }

    public InternalInventory getInternalInventory() {
        return this.gridInv;
    }

    public InternalInventory getExposedInventoryForSide() {
        return this.gridInvExt;
    }

    public int getCraftingProgress() {
        return (int)this.progress;
    }

    public TickRateModulation tick(int cards, int ticksSinceLastCall) {
        if (!this.gridInv.getStackInSlot(9).isEmpty()) {
            this.pushOut(this.gridInv.getStackInSlot(9));
            if (this.gridInv.getStackInSlot(9).isEmpty()) {
                this.saveChanges();
            }
            this.ejectHeldItems();
            this.updateSleepiness();
            this.progress = 0.0;
            return this.isAwake ? TickRateModulation.IDLE : TickRateModulation.SLEEP;
        }
        if (this.myPlan == null) {
            this.ejectHeldItems();
            this.updateSleepiness();
            return TickRateModulation.SLEEP;
        }
        if (this.reboot) {
            ticksSinceLastCall = 1;
        }
        if (!this.isAwake) {
            return TickRateModulation.SLEEP;
        }
        this.reboot = false;
        switch (cards) {
            case 0: {
                this.progress += (double)this.userPower(ticksSinceLastCall, 20, 1.0);
                break;
            }
            case 1: {
                this.progress += (double)this.userPower(ticksSinceLastCall, 26, 1.3);
                break;
            }
            case 2: {
                this.progress += (double)this.userPower(ticksSinceLastCall, 34, 1.7);
                break;
            }
            case 3: {
                this.progress += (double)this.userPower(ticksSinceLastCall, 40, 2.0);
                break;
            }
            case 4: {
                this.progress += (double)this.userPower(ticksSinceLastCall, 50, 2.5);
                break;
            }
            case 5: {
                this.progress += (double)this.userPower(ticksSinceLastCall, 100, 5.0);
            }
        }
        if (this.progress >= 100.0) {
            for (int x = 0; x < this.craftingInv.getContainerSize(); ++x) {
                this.craftingInv.setItem(x, this.gridInv.getStackInSlot(x));
            }
            CraftingInput.Positioned positionedInput = this.craftingInv.asPositionedCraftInput();
            CraftingInput craftinginput = positionedInput.input();
            this.progress = 0.0;
            this.output = this.myPlan.assemble(craftinginput, this.host.getLevel());
            if (!this.output.isEmpty() && this.host.getLevel() != null) {
                int idx;
                int x;
                int y;
                this.output.onCraftedBySystem(this.host.getLevel());
                NonNullList craftingRemainders = this.myPlan.getRemainingItems(craftinginput);
                this.pushOut(this.output.copy());
                int craftingInputLeft = positionedInput.left();
                int craftingInputTop = positionedInput.top();
                for (y = 0; y < this.craftingInv.getHeight(); ++y) {
                    for (x = 0; x < this.craftingInv.getWidth(); ++x) {
                        if (y >= craftingInputTop && x >= craftingInputLeft) continue;
                        idx = x + y * this.craftingInv.getWidth();
                        this.gridInv.setItemDirect(idx, ItemStack.EMPTY);
                    }
                }
                for (y = 0; y < craftinginput.height(); ++y) {
                    for (x = 0; x < craftinginput.width(); ++x) {
                        idx = x + craftingInputLeft + (y + craftingInputTop) * this.craftingInv.getWidth();
                        this.gridInv.setItemDirect(idx, (ItemStack)craftingRemainders.get(x + y * craftinginput.width()));
                    }
                }
                this.forcePlan = false;
                this.myPlan = null;
                this.pushDirection = null;
                this.ejectHeldItems();
                this.saveChanges();
                this.updateSleepiness();
                return this.isAwake ? TickRateModulation.IDLE : TickRateModulation.SLEEP;
            }
            ExtendedAE.LOGGER.warn("Molecular Assembler failed to craft, the crafting ingredients are returned.");
            this.forcePlan = false;
            this.myPlan = null;
            this.pushDirection = null;
            this.ejectHeldItems();
            this.saveChanges();
            this.updateSleepiness();
        }
        return TickRateModulation.FASTER;
    }

    public void forceAwake() {
        this.isAwake = true;
    }

    public void recalculatePlan() {
        this.reboot = true;
        if (this.forcePlan) {
            if (this.host.getLevel() != null && this.myPlan == null) {
                IPatternDetails iPatternDetails;
                if (!this.myPattern.isEmpty() && (iPatternDetails = PatternDetailsHelper.decodePattern((ItemStack)this.myPattern, (Level)this.host.getLevel())) instanceof IMolecularAssemblerSupportedPattern) {
                    IMolecularAssemblerSupportedPattern supportedPlan;
                    this.myPlan = supportedPlan = (IMolecularAssemblerSupportedPattern)iPatternDetails;
                }
                this.myPattern = ItemStack.EMPTY;
                if (this.myPlan == null) {
                    AELog.warn((String)"Unable to restore auto-crafting pattern after load: %s", (Object[])new Object[]{this.myPattern});
                    this.forcePlan = false;
                }
            }
            return;
        }
        this.progress = 0.0;
        this.myPlan = null;
        this.myPattern = ItemStack.EMPTY;
        this.pushDirection = null;
        this.updateSleepiness();
    }

    @Nullable
    public IMolecularAssemblerSupportedPattern getCurrentPattern() {
        if (this.host.isClientSide()) {
            return null;
        }
        return this.myPlan;
    }

    private int userPower(int ticksPassed, int bonusValue, double acceleratorTax) {
        IGrid grid = this.girdHost.getMainNode().getGrid();
        if (grid != null) {
            double safePower = Math.min((double)(ticksPassed * bonusValue) * acceleratorTax, 5000.0);
            return (int)(grid.getEnergyService().extractAEPower(safePower, Actionable.MODULATE, PowerMultiplier.CONFIG) / acceleratorTax);
        }
        return 0;
    }

    private void ejectHeldItems() {
        if (this.gridInv.getStackInSlot(9).isEmpty()) {
            for (int x = 0; x < 9; ++x) {
                ItemStack is = this.gridInv.getStackInSlot(x);
                if (is.isEmpty() || this.myPlan != null && this.myPlan.isItemValid(x, AEItemKey.of((ItemStack)is), this.host.getLevel())) continue;
                this.gridInv.setItemDirect(9, is);
                this.gridInv.setItemDirect(x, ItemStack.EMPTY);
                this.saveChanges();
                return;
            }
        }
    }

    protected void pushOut(ItemStack output) {
        if (this.pushDirection == null) {
            for (Direction d : Direction.values()) {
                output = this.pushTo(output, d);
            }
        } else {
            output = this.pushTo(output, this.pushDirection);
        }
        if (output.isEmpty() && this.forcePlan) {
            this.forcePlan = false;
            this.recalculatePlan();
        }
        this.gridInv.setItemDirect(9, output);
    }

    protected final void saveChanges() {
        this.host.saveChanges();
    }

    private ItemStack pushTo(ItemStack output, Direction d) {
        int newSize;
        if (output.isEmpty() || this.host.getLevel() == null) {
            return output;
        }
        BlockEntity te = this.host.getLevel().getBlockEntity(this.host.getBlockPos().relative(d));
        if (te == null) {
            return output;
        }
        ItemTransfer adaptor = InternalInventory.wrapExternal((Level)this.host.getLevel(), (BlockPos)te.getBlockPos(), (Direction)d.getOpposite());
        if (adaptor == null) {
            return output;
        }
        int size = output.getCount();
        int n = newSize = (output = adaptor.addItems(output)).isEmpty() ? 0 : output.getCount();
        if (size != newSize) {
            this.saveChanges();
        }
        return output;
    }

    private void fillGrid(KeyCounter[] table, IMolecularAssemblerSupportedPattern adapter) {
        adapter.fillCraftingGrid(table, (arg_0, arg_1) -> ((AppEngInternalInventory)this.gridInv).setItemDirect(arg_0, arg_1));
        for (KeyCounter list : table) {
            list.removeZeros();
            if (list.isEmpty()) continue;
            throw new RuntimeException("Could not fill grid with some items, including " + String.valueOf(list.iterator().next()));
        }
    }

    public void updateSleepiness() {
        boolean wasEnabled = this.isAwake;
        boolean bl = this.isAwake = this.myPlan != null && this.hasMats() || this.canPush();
        if (wasEnabled != this.isAwake) {
            this.girdHost.getMainNode().ifPresent((grid, node) -> {
                if (this.isAwake) {
                    grid.getTickManager().wakeDevice(node);
                } else {
                    grid.getTickManager().sleepDevice(node);
                }
            });
        }
    }

    private boolean hasMats() {
        if (this.myPlan == null) {
            return false;
        }
        for (int x = 0; x < this.craftingInv.getContainerSize(); ++x) {
            this.craftingInv.setItem(x, this.gridInv.getStackInSlot(x));
        }
        return !this.myPlan.assemble(this.craftingInv.asCraftInput(), this.host.getLevel()).isEmpty();
    }

    private boolean canPush() {
        return !this.gridInv.getStackInSlot(9).isEmpty();
    }

    public ItemStack getOutput() {
        return this.output;
    }

    private static class CraftingGridFilter
    implements IAEItemFilter {
        private CraftingGridFilter() {
        }

        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return slot == 9;
        }

        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            return false;
        }
    }
}

