/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.level.BlockEvent;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.StatLabel;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.core.handler.ConfigHandler;

public class PieceTrickBreakBlock
extends PieceTrick {
    private static final List<List<ItemStack>> HARVEST_TOOLS_BY_LEVEL = List.of(PieceTrickBreakBlock.stacks(Items.WOODEN_PICKAXE, Items.WOODEN_AXE, Items.WOODEN_HOE, Items.WOODEN_SHOVEL), PieceTrickBreakBlock.stacks(Items.STONE_PICKAXE, Items.STONE_AXE, Items.STONE_HOE, Items.STONE_SHOVEL), PieceTrickBreakBlock.stacks(Items.IRON_PICKAXE, Items.IRON_AXE, Items.IRON_HOE, Items.IRON_SHOVEL), PieceTrickBreakBlock.stacks(Items.DIAMOND_PICKAXE, Items.DIAMOND_AXE, Items.DIAMOND_HOE, Items.DIAMOND_SHOVEL), PieceTrickBreakBlock.stacks(Items.NETHERITE_PICKAXE, Items.NETHERITE_AXE, Items.NETHERITE_HOE, Items.NETHERITE_SHOVEL));
    public static ThreadLocal<Boolean> doingHarvestCheck = ThreadLocal.withInitial(() -> false);
    SpellParam<Vector3> position;

    public PieceTrickBreakBlock(Spell spell) {
        super(spell);
        this.setStatLabel(EnumSpellStat.POTENCY, new StatLabel(20.0));
        this.setStatLabel(EnumSpellStat.COST, new StatLabel(50.0));
    }

    public static void removeBlockWithDrops(SpellContext context, Player player, Level world, ItemStack stack, BlockPos pos, Predicate<BlockState> filter) {
        boolean unminable;
        if (stack.isEmpty()) {
            stack = PsiAPI.getPlayerCAD(player);
        }
        if (!world.hasChunkAt(pos)) {
            return;
        }
        BlockState blockstate = world.getBlockState(pos);
        boolean bl = unminable = blockstate.getDestroySpeed((BlockGetter)world, pos) == -1.0f;
        if (!world.isClientSide && !unminable && filter.test(blockstate) && !blockstate.isAir()) {
            ItemStack save = player.getMainHandItem();
            boolean wasChecking = doingHarvestCheck.get();
            doingHarvestCheck.set(true);
            player.setItemInHand(InteractionHand.MAIN_HAND, stack);
            ((ServerPlayer)player).connection.send((Packet)new ClientboundLevelEventPacket(2001, pos, Block.getId((BlockState)blockstate), false));
            ((ServerPlayer)player).gameMode.destroyBlock(pos);
            doingHarvestCheck.set(wasChecking);
            player.setItemInHand(InteractionHand.MAIN_HAND, save);
        }
    }

    public static BlockEvent.BreakEvent createBreakEvent(BlockState state, Player player, Level world, BlockPos pos, ItemStack tool) {
        return new BlockEvent.BreakEvent(world, pos, state, player);
    }

    public static boolean canHarvestBlock(BlockState state, Player player, Level world, BlockPos pos, ItemStack stack) {
        boolean wasChecking = doingHarvestCheck.get();
        doingHarvestCheck.set(true);
        ItemStack oldHeldStack = player.getMainHandItem();
        player.getInventory().items.set(player.getInventory().selected, (Object)stack);
        boolean canHarvest = state.canHarvestBlock((BlockGetter)world, pos, player);
        player.getInventory().items.set(player.getInventory().selected, (Object)oldHeldStack);
        doingHarvestCheck.set(wasChecking);
        return canHarvest;
    }

    private static List<ItemStack> stacks(Item ... items) {
        return Stream.of(items).map(ItemStack::new).collect(Collectors.toList());
    }

    public static boolean canHarvest(int harvestLevel, BlockState state) {
        return !PieceTrickBreakBlock.getTool(harvestLevel, state).isEmpty();
    }

    private static ItemStack getTool(int harvestLevel, BlockState state) {
        if (!state.requiresCorrectToolForDrops()) {
            return HARVEST_TOOLS_BY_LEVEL.getFirst().getFirst();
        }
        int idx = Math.min(harvestLevel, HARVEST_TOOLS_BY_LEVEL.size() - 1);
        for (ItemStack tool : HARVEST_TOOLS_BY_LEVEL.get(idx)) {
            if (!tool.isCorrectToolForDrops(state)) continue;
            return tool;
        }
        return ItemStack.EMPTY;
    }

    public static int getHarvestLevel(BlockState state) {
        if (Items.AIR.isCorrectToolForDrops(Items.AIR.getDefaultInstance(), state)) {
            return 0;
        }
        for (int i = 0; i < HARVEST_TOOLS_BY_LEVEL.size(); ++i) {
            for (ItemStack tool : HARVEST_TOOLS_BY_LEVEL.get(i)) {
                if (!tool.isCorrectToolForDrops(state)) continue;
                return i + 1;
            }
        }
        return HARVEST_TOOLS_BY_LEVEL.size() + 1;
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        meta.addStat(EnumSpellStat.POTENCY, 20);
        meta.addStat(EnumSpellStat.COST, 50);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        ItemStack tool = context.getHarvestTool();
        Vector3 positionVal = this.getParamValue(context, this.position);
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector", new Object[0]);
        }
        if (!context.isInRadius(positionVal)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius", new Object[0]);
        }
        BlockPos pos = positionVal.toBlockPos();
        PieceTrickBreakBlock.removeBlockWithDrops(context, context.caster, context.focalPoint.getCommandSenderWorld(), tool, pos, v -> tool.isCorrectToolForDrops(v) || PieceTrickBreakBlock.canHarvest((Integer)ConfigHandler.COMMON.cadHarvestLevel.get(), v));
        return null;
    }
}

