/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.other;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.Material;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import vazkii.psi.api.spell.EnumPieceType;
import vazkii.psi.api.spell.IRedirector;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.param.ParamAny;

public class PieceConnector
extends SpellPiece
implements IRedirector {
    public static final ResourceLocation LINES_TEXTURE = ResourceLocation.parse((String)"psi:spell/connector_lines");
    public SpellParam<SpellParam.Any> target;

    public PieceConnector(Spell spell) {
        super(spell);
    }

    @Override
    public String getSortingName() {
        return "00000000000";
    }

    @Override
    public Component getEvaluationTypeString() {
        return Component.translatable((String)"psi.datatype.any");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawAdditional(PoseStack pPoseStack, MultiBufferSource buffers, int light) {
        this.drawSide(pPoseStack, buffers, light, (SpellParam.Side)((Object)this.paramSides.get(this.target)));
        if (this.isInGrid) {
            for (SpellParam.Side side : (SpellParam.Side[])SpellParam.Side.class.getEnumConstants()) {
                SpellPiece piece;
                if (!side.isEnabled() || (piece = this.spell.grid.getPieceAtSideSafely(this.x, this.y, side)) == null || !piece.isInputSide(side.getOpposite())) continue;
                this.drawSide(pPoseStack, buffers, light, side);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawSide(PoseStack pPoseStack, MultiBufferSource buffers, int light, SpellParam.Side side) {
        if (side.isEnabled()) {
            Material material = new Material(InventoryMenu.BLOCK_ATLAS, LINES_TEXTURE);
            VertexConsumer buffer = material.buffer(buffers, ignored -> SpellPiece.getLayer());
            float minU = 0.0f;
            float minV = 0.0f;
            switch (side) {
                case LEFT: {
                    minU = 0.5f;
                    break;
                }
                default: {
                    break;
                }
                case TOP: {
                    minV = 0.5f;
                    break;
                }
                case BOTTOM: {
                    minU = 0.5f;
                    minV = 0.5f;
                }
            }
            float maxU = minU + 0.5f;
            float maxV = minV + 0.5f;
            Matrix4f mat = pPoseStack.last().pose();
            buffer.addVertex(mat, 0.0f, 16.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
            buffer.setUv(minU, maxV).setLight(light);
            buffer.addVertex(mat, 16.0f, 16.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
            buffer.setUv(maxU, maxV).setLight(light);
            buffer.addVertex(mat, 16.0f, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
            buffer.setUv(maxU, minV).setLight(light);
            buffer.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
            buffer.setUv(minU, minV).setLight(light);
        }
    }

    @Override
    public void getShownPieces(List<SpellPiece> pieces) {
        for (SpellParam.Side side : (SpellParam.Side[])SpellParam.Side.class.getEnumConstants()) {
            if (!side.isEnabled()) continue;
            PieceConnector piece = (PieceConnector)SpellPiece.create(PieceConnector.class, new Spell());
            piece.paramSides.put(piece.target, side);
            pieces.add(piece);
        }
    }

    @Override
    public void initParams() {
        this.target = new ParamAny("psi.spellparam.target", SpellParam.GRAY, false);
        this.addParam(this.target);
    }

    @Override
    public EnumPieceType getPieceType() {
        return EnumPieceType.CONNECTOR;
    }

    @Override
    public SpellParam.Side getRedirectionSide() {
        return (SpellParam.Side)((Object)this.paramSides.get(this.target));
    }

    @Override
    public Class<?> getEvaluationType() {
        return null;
    }

    @Override
    public Object evaluate() {
        return null;
    }

    @Override
    public Object execute(SpellContext context) {
        return null;
    }
}

