/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.crafting.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.data.loading.DatagenModLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.psi.common.crafting.ModCraftingRecipes;
import vazkii.psi.common.item.ItemSpellBullet;

public class BulletUpgradeRecipe
extends ShapelessRecipe {
    public final String group;
    public final CraftingBookCategory category;
    public final ItemStack result;
    public final NonNullList<Ingredient> ingredients;

    public BulletUpgradeRecipe(String pGroup, CraftingBookCategory pCategory, ItemStack pResult, NonNullList<Ingredient> pIngredients) {
        super(pGroup, pCategory, pResult, pIngredients);
        this.group = pGroup;
        this.category = pCategory;
        this.result = pResult;
        this.ingredients = pIngredients;
    }

    @NotNull
    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider access) {
        ItemStack output = super.assemble(inv, access);
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (!(stack.getItem() instanceof ItemSpellBullet)) continue;
            output = stack.transmuteCopy((ItemLike)output.getItem(), 1);
            break;
        }
        return output;
    }

    @NotNull
    public RecipeType<?> getType() {
        return !DatagenModLoader.isRunningDataGen() ? RecipeType.CRAFTING : (RecipeType)ModCraftingRecipes.BULLET_UPGRADE_TYPE.get();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return !DatagenModLoader.isRunningDataGen() ? RecipeSerializer.SHAPELESS_RECIPE : (RecipeSerializer)ModCraftingRecipes.BULLET_UPGRADE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<BulletUpgradeRecipe> {
        private static final MapCodec<BulletUpgradeRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(r -> r.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(r -> r.category), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(r -> r.result), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(p_301021_ -> {
            Object[] aingredient = (Ingredient[])p_301021_.toArray(Ingredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return aingredient.length > ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth() ? DataResult.error(() -> "Too many ingredients for shapeless recipe. The maximum is: %s".formatted(ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxHeight())) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
        }, DataResult::success).forGetter(r -> r.ingredients)).apply((Applicative)instance, BulletUpgradeRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BulletUpgradeRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<BulletUpgradeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BulletUpgradeRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static BulletUpgradeRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String s = buffer.readUtf();
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
            int i = buffer.readVarInt();
            NonNullList nonnulllist = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            nonnulllist.replaceAll(p_319735_ -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new BulletUpgradeRecipe(s, craftingbookcategory, itemstack, (NonNullList<Ingredient>)nonnulllist);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, BulletUpgradeRecipe recipe) {
            buffer.writeUtf(recipe.group);
            buffer.writeEnum((Enum)recipe.category);
            buffer.writeVarInt(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
        }
    }

    public static class Builder
    implements RecipeBuilder {
        private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
        @Nullable
        private String group;
        private final Item result;
        private final NonNullList<Ingredient> ingredients = NonNullList.create();

        public Builder(Item result) {
            this.result = result;
        }

        @NotNull
        public RecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
            this.criteria.put(name, criterion);
            return this;
        }

        @NotNull
        public RecipeBuilder group(@Nullable String groupName) {
            this.group = groupName;
            return this;
        }

        @NotNull
        public Item getResult() {
            return this.result;
        }

        public Builder requires(Ingredient ingredient) {
            this.ingredients.add((Object)ingredient);
            return this;
        }

        public Builder requires(ItemLike item) {
            return this.requires(Ingredient.of((ItemLike[])new ItemLike[]{item}));
        }

        private void ensureValid(ResourceLocation id) {
            if (this.criteria.isEmpty()) {
                throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
            }
            if (!(this.result instanceof ItemSpellBullet)) {
                throw new IllegalStateException("Recipe " + String.valueOf(id) + " should produce an item that extends ItemSpellBullet");
            }
        }

        public void save(RecipeOutput recipeOutput, ResourceLocation id) {
            this.ensureValid(id);
            Advancement.Builder advancement$builder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
            this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
            BulletUpgradeRecipe shapelessrecipe = new BulletUpgradeRecipe(Objects.requireNonNullElse(this.group, ""), CraftingBookCategory.EQUIPMENT, this.result.getDefaultInstance(), this.ingredients);
            recipeOutput.accept(id, (Recipe)shapelessrecipe, advancement$builder.build(id.withPrefix("recipes/bullet_upgrade/")));
        }
    }
}

