/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.core.handler.capability;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.ItemStackHandler;
import vazkii.psi.api.cad.ISocketable;

public class SocketWheel
implements ISocketable,
INBTSerializable<CompoundTag> {
    private final int size;
    private final ItemStackHandler handler;
    private int selectedSlot = 0;

    public SocketWheel() {
        this(12);
    }

    public SocketWheel(int size) {
        this.size = size;
        this.handler = new ItemStackHandler(size);
    }

    @Override
    public boolean isSocketSlotAvailable(int slot) {
        return slot < this.size && slot >= 0;
    }

    @Override
    public List<Integer> getRadialMenuSlots() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.size; ++i) {
            if (!this.isSocketSlotAvailable(i)) continue;
            list.add(i);
        }
        return list;
    }

    @Override
    public ItemStack getBulletInSocket(int slot) {
        return this.handler.getStackInSlot(slot);
    }

    @Override
    public void setBulletInSocket(int slot, ItemStack bullet) {
        this.handler.setStackInSlot(slot, bullet);
    }

    @Override
    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    @Override
    public void setSelectedSlot(int slot) {
        this.selectedSlot = slot;
    }

    @Override
    public int getLastSlot() {
        return this.size - 1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack bullet) {
        return this.handler.insertItem(slot, bullet, true).isEmpty();
    }

    @Override
    public boolean canLoopcast() {
        return false;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compound = this.handler.serializeNBT(provider);
        compound.remove("Size");
        return compound;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        nbt.putInt("Size", this.size);
        this.handler.deserializeNBT(provider, nbt);
    }
}

