/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.block.tile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.common.block.BlockProgrammer;
import vazkii.psi.common.block.base.ModBlocks;
import vazkii.psi.common.spell.SpellCompiler;

public class TileProgrammer
extends BlockEntity {
    private static final String TAG_SPELL = "spell";
    private static final String TAG_PLAYER_LOCK = "playerLock";
    public Spell spell;
    public boolean enabled;
    public String playerLock = "";

    public TileProgrammer(BlockPos pos, BlockState state) {
        super(ModBlocks.programmerType, pos, state);
    }

    public boolean isEnabled() {
        return this.spell != null && !this.spell.grid.isEmpty();
    }

    public boolean canCompile() {
        return this.isEnabled() && new SpellCompiler().compile(this.spell).left().isPresent();
    }

    public void onSpellChanged() {
        boolean wasEnabled = this.enabled;
        this.enabled = this.isEnabled();
        if (wasEnabled != this.enabled) {
            this.getLevel().setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)BlockProgrammer.ENABLED, (Comparable)Boolean.valueOf(this.enabled)));
        }
        this.setChanged();
    }

    public void loadAdditional(CompoundTag cmp, HolderLookup.Provider pRegistries) {
        super.loadAdditional(cmp, pRegistries);
        this.readPacketNBT(cmp);
    }

    @NotNull
    public void saveAdditional(CompoundTag cmp, HolderLookup.Provider pRegistries) {
        super.saveAdditional(cmp, pRegistries);
        CompoundTag spellCmp = new CompoundTag();
        if (this.spell != null) {
            this.spell.writeToNBT(spellCmp);
        }
        cmp.put(TAG_SPELL, (Tag)spellCmp);
        cmp.putString(TAG_PLAYER_LOCK, this.playerLock);
    }

    public void readPacketNBT(CompoundTag cmp) {
        CompoundTag spellCmp = cmp.getCompound(TAG_SPELL);
        if (this.spell == null) {
            this.spell = Spell.createFromNBT(spellCmp);
        } else {
            this.spell.readFromNBT(spellCmp);
        }
        this.playerLock = cmp.getString(TAG_PLAYER_LOCK);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag cmp = new CompoundTag();
        this.saveAdditional(cmp, pRegistries);
        return cmp;
    }

    public boolean canPlayerInteract(Player player) {
        return player.isAlive() && player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        this.readPacketNBT(pkt.getTag());
    }
}

