/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.block.tile;

import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.common.Psi;
import vazkii.psi.common.block.BlockConjured;
import vazkii.psi.common.block.base.ModBlocks;

public class TileConjured
extends BlockEntity {
    private static final String TAG_COLORIZER = "colorizer";
    public ItemStack colorizer = ItemStack.EMPTY;

    public TileConjured(BlockPos pos, BlockState state) {
        super(ModBlocks.conjuredType, pos, state);
    }

    public void doParticles() {
        int color = Psi.proxy.getColorForColorizer(this.colorizer);
        float r = (float)PsiRenderHelper.r(color) / 255.0f;
        float g = (float)PsiRenderHelper.g(color) / 255.0f;
        float b = (float)PsiRenderHelper.b(color) / 255.0f;
        BlockState state = this.getLevel().getBlockState(this.getBlockPos());
        if (state.getBlock() == ModBlocks.conjured && ((Boolean)state.getValue((Property)BlockConjured.SOLID)).booleanValue()) {
            boolean[] edges = new boolean[12];
            Arrays.fill(edges, true);
            if (((Boolean)state.getValue((Property)BlockConjured.BLOCK_DOWN)).booleanValue()) {
                this.removeEdges(edges, 0, 1, 2, 3);
            }
            if (((Boolean)state.getValue((Property)BlockConjured.BLOCK_UP)).booleanValue()) {
                this.removeEdges(edges, 4, 5, 6, 7);
            }
            if (((Boolean)state.getValue((Property)BlockConjured.BLOCK_NORTH)).booleanValue()) {
                this.removeEdges(edges, 3, 7, 8, 11);
            }
            if (((Boolean)state.getValue((Property)BlockConjured.BLOCK_SOUTH)).booleanValue()) {
                this.removeEdges(edges, 1, 5, 9, 10);
            }
            if (((Boolean)state.getValue((Property)BlockConjured.BLOCK_EAST)).booleanValue()) {
                this.removeEdges(edges, 2, 6, 10, 11);
            }
            if (((Boolean)state.getValue((Property)BlockConjured.BLOCK_WEST)).booleanValue()) {
                this.removeEdges(edges, 0, 4, 8, 9);
            }
            double x = this.getBlockPos().getX();
            double y = this.getBlockPos().getY();
            double z = this.getBlockPos().getZ();
            this.makeParticle(edges[0], r, g, b, x + 0.0, y + 0.0, z + 0.0, 0.0, 0.0, 1.0);
            this.makeParticle(edges[1], r, g, b, x + 0.0, y + 0.0, z + 1.0, 1.0, 0.0, 0.0);
            this.makeParticle(edges[2], r, g, b, x + 1.0, y + 0.0, z + 0.0, 0.0, 0.0, 1.0);
            this.makeParticle(edges[3], r, g, b, x + 0.0, y + 0.0, z + 0.0, 1.0, 0.0, 0.0);
            this.makeParticle(edges[4], r, g, b, x + 0.0, y + 1.0, z + 0.0, 0.0, 0.0, 1.0);
            this.makeParticle(edges[5], r, g, b, x + 0.0, y + 1.0, z + 1.0, 1.0, 0.0, 0.0);
            this.makeParticle(edges[6], r, g, b, x + 1.0, y + 1.0, z + 0.0, 0.0, 0.0, 1.0);
            this.makeParticle(edges[7], r, g, b, x + 0.0, y + 1.0, z + 0.0, 1.0, 0.0, 0.0);
            this.makeParticle(edges[8], r, g, b, x + 0.0, y + 0.0, z + 0.0, 0.0, 1.0, 0.0);
            this.makeParticle(edges[9], r, g, b, x + 0.0, y + 0.0, z + 1.0, 0.0, 1.0, 0.0);
            this.makeParticle(edges[10], r, g, b, x + 1.0, y + 0.0, z + 1.0, 0.0, 1.0, 0.0);
            this.makeParticle(edges[11], r, g, b, x + 1.0, y + 0.0, z + 0.0, 0.0, 1.0, 0.0);
        } else if (Math.random() < 0.5) {
            float w = 0.15f;
            float h = 0.05f;
            double x = (double)this.getBlockPos().getX() + 0.5 + (Math.random() - 0.5) * (double)w;
            double y = (double)this.getBlockPos().getY() + 0.25 + (Math.random() - 0.5) * (double)h;
            double z = (double)this.getBlockPos().getZ() + 0.5 + (Math.random() - 0.5) * (double)w;
            float s = 0.2f + (float)Math.random() * 0.1f;
            float m = 0.01f + (float)Math.random() * 0.015f;
            Psi.proxy.wispFX(x, y, z, r, g, b, s, -m);
        }
    }

    public void makeParticle(boolean doit, float r, float g, float b, double xp, double yp, double zp, double xv, double yv, double zv) {
        if (doit) {
            float m = 0.1f;
            Psi.proxy.sparkleFX(xp, yp, zp, r, g, b, (float)(xv *= (double)m), (float)(yv *= (double)m), (float)(zv *= (double)m), 2.75f, 15);
        }
    }

    public void removeEdges(boolean[] edges, int ... posArray) {
        for (int i : posArray) {
            edges[i] = false;
        }
    }

    @NotNull
    public void saveAdditional(CompoundTag cmp, HolderLookup.Provider pRegistries) {
        super.saveAdditional(cmp, pRegistries);
        if (!this.colorizer.isEmpty()) {
            cmp.put(TAG_COLORIZER, this.colorizer.save(pRegistries, (Tag)new CompoundTag()));
        }
    }

    public void loadAdditional(CompoundTag cmp, HolderLookup.Provider pRegistries) {
        super.loadAdditional(cmp, pRegistries);
        this.readPacketNBT(cmp, pRegistries);
    }

    public void readPacketNBT(CompoundTag cmp, HolderLookup.Provider pRegistries) {
        this.colorizer = cmp.contains(TAG_COLORIZER) ? ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)cmp.getCompound(TAG_COLORIZER)) : ItemStack.EMPTY;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag cmp = new CompoundTag();
        this.saveAdditional(cmp, pRegistries);
        return cmp;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        if (pkt != null && pkt.getTag() != null) {
            this.readPacketNBT(pkt.getTag(), pRegistries);
        }
    }
}

