/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.model;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import vazkii.psi.client.model.ModModelLayers;
import vazkii.psi.client.model.ModelArmor;
import vazkii.psi.common.item.armor.ItemPsimetalArmor;

public class ArmorModels {
    private static Map<EquipmentSlot, ModelArmor> exosuit = Collections.emptyMap();

    private static Map<EquipmentSlot, ModelArmor> make(EntityRendererProvider.Context ctx, ModelLayerLocation inner, ModelLayerLocation outer) {
        EnumMap<EquipmentSlot, ModelArmor> ret = new EnumMap<EquipmentSlot, ModelArmor>(EquipmentSlot.class);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ModelPart mesh = ctx.bakeLayer(slot == EquipmentSlot.LEGS ? inner : outer);
            ret.put(slot, new ModelArmor(mesh, slot));
        }
        return ret;
    }

    public static void init(EntityRendererProvider.Context ctx) {
        exosuit = ArmorModels.make(ctx, ModModelLayers.PSIMETAL_EXOSUIT_INNER_ARMOR, ModModelLayers.PSIMETAL_EXOSUIT_OUTER_ARMOR);
    }

    @Nullable
    public static ModelArmor get(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof ItemPsimetalArmor) {
            ItemPsimetalArmor armor = (ItemPsimetalArmor)item;
            return exosuit.get(armor.getEquipmentSlot());
        }
        return null;
    }
}

