/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.jetbrains.annotations.Nullable;
import vazkii.psi.api.spell.SpellGrid;
import vazkii.psi.api.spell.SpellPiece;

public final class Spell {
    public static final String TAG_SPELL_NAME = "spellName";
    public static final String TAG_UUID_MOST = "uuidMost";
    public static final String TAG_UUID_LEAST = "uuidLeast";
    public static final String TAG_MODS_REQUIRED = "modsRequired";
    public static final String TAG_MOD_NAME = "modName";
    public static final String TAG_MOD_VERSION = "modVersion";
    private static final String TAG_VALID = "validSpell";
    public final SpellGrid grid = new SpellGrid(this);
    public String name = "";
    public UUID uuid = UUID.randomUUID();
    public static final MapCodec<Spell> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf(TAG_VALID).forGetter(s -> true), (App)Codec.STRING.fieldOf(TAG_SPELL_NAME).forGetter(s -> s.name), (App)Codec.list((Codec)ModInformation.CODEC.codec()).fieldOf(TAG_MODS_REQUIRED).forGetter(Spell::getModInformationForCodec), (App)Codec.LONG.fieldOf(TAG_UUID_MOST).forGetter(s -> s.uuid.getMostSignificantBits()), (App)Codec.LONG.fieldOf(TAG_UUID_LEAST).forGetter(s -> s.uuid.getLeastSignificantBits()), (App)Codec.lazyInitialized(() -> SpellGrid.CODEC.codec()).fieldOf("spellList").forGetter(s -> s.grid)).apply((Applicative)instance, Spell::fromCodecData));
    public static final StreamCodec<RegistryFriendlyByteBuf, Spell> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, s -> true, (StreamCodec)ByteBufCodecs.STRING_UTF8, s -> s.name, (StreamCodec)ModInformation.STREAM_CODEC.apply(ByteBufCodecs.list()), Spell::getModInformationForCodec, (StreamCodec)ByteBufCodecs.VAR_LONG, s -> s.uuid.getMostSignificantBits(), (StreamCodec)ByteBufCodecs.VAR_LONG, s -> s.uuid.getLeastSignificantBits(), (StreamCodec)NeoForgeStreamCodecs.lazy(() -> SpellGrid.STREAM_CODEC), s -> s.grid, Spell::fromCodecData);

    @Nullable
    public static Spell createFromNBT(CompoundTag cmp) {
        if (cmp == null || !cmp.getBoolean(TAG_VALID)) {
            return null;
        }
        Spell spell = new Spell();
        spell.readFromNBT(cmp);
        return spell;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(PoseStack pPoseStack, MultiBufferSource buffers, int light) {
        this.grid.draw(pPoseStack, buffers, light);
    }

    public void readFromNBT(CompoundTag cmp) {
        this.name = cmp.getString(TAG_SPELL_NAME);
        if (cmp.contains(TAG_UUID_MOST)) {
            long uuidMost = cmp.getLong(TAG_UUID_MOST);
            long uuidLeast = cmp.getLong(TAG_UUID_LEAST);
            if (this.uuid.getMostSignificantBits() != uuidMost || this.uuid.getLeastSignificantBits() != uuidLeast) {
                this.uuid = new UUID(uuidMost, uuidLeast);
            }
        }
        this.grid.readFromNBT(cmp);
    }

    public Set<String> getPieceNamespaces() {
        Set<String> temp = Collections.newSetFromMap(new HashMap());
        SpellPiece[][] spellPieceArray = this.grid.gridData;
        int n = spellPieceArray.length;
        for (int i = 0; i < n; ++i) {
            SpellPiece[] gridDatum;
            for (SpellPiece spellPiece : gridDatum = spellPieceArray[i]) {
                if (spellPiece == null) continue;
                temp.add(spellPiece.registryKey.getNamespace());
            }
        }
        return temp;
    }

    private static Spell fromCodecData(boolean valid, String spellName, List<ModInformation> modsRequired, long uuidMost, long uuidLeast, SpellGrid grid) {
        Spell spell = new Spell();
        spell.name = spellName;
        spell.uuid = new UUID(uuidMost, uuidLeast);
        spell.grid.gridData = new SpellPiece[9][9];
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                SpellPiece piece = grid.gridData[i][j];
                if (piece == null) continue;
                spell.grid.gridData[i][j] = piece.copyFromSpell(spell);
                spell.grid.gridData[i][j].x = i;
                spell.grid.gridData[i][j].y = j;
            }
        }
        return spell;
    }

    private List<ModInformation> getModInformationForCodec() {
        ArrayList<ModInformation> info = new ArrayList<ModInformation>();
        for (String namespace : this.getPieceNamespaces()) {
            Optional optionalMod = ModList.get().getModContainerById(namespace);
            if (optionalMod.isEmpty()) continue;
            ModContainer mod = (ModContainer)optionalMod.get();
            info.add(new ModInformation(mod.getModId(), mod.getModInfo().getVersion().toString()));
        }
        info.sort(Comparator.comparing(i -> i.name));
        return info;
    }

    public void writeToNBT(CompoundTag cmp) {
        cmp.putBoolean(TAG_VALID, true);
        cmp.putString(TAG_SPELL_NAME, this.name);
        ListTag modList = new ListTag();
        for (String namespace : this.getPieceNamespaces()) {
            CompoundTag nbt = new CompoundTag();
            nbt.putString(TAG_MOD_NAME, namespace);
            if (ModList.get().getModContainerById(namespace).isPresent()) {
                nbt.putString(TAG_MOD_VERSION, ((ModContainer)ModList.get().getModContainerById(namespace).get()).getModInfo().getVersion().toString());
            }
            modList.add((Object)nbt);
        }
        cmp.put(TAG_MODS_REQUIRED, (Tag)modList);
        cmp.putLong(TAG_UUID_MOST, this.uuid.getMostSignificantBits());
        cmp.putLong(TAG_UUID_LEAST, this.uuid.getLeastSignificantBits());
        this.grid.writeToNBT(cmp);
    }

    public Spell copy() {
        CompoundTag cmp = new CompoundTag();
        this.writeToNBT(cmp);
        return Spell.createFromNBT(cmp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Spell)) return false;
        Spell o = (Spell)obj;
        if (!Objects.equals(this.name, o.name)) return false;
        if (!Objects.equals(this.grid, o.grid)) return false;
        return true;
    }

    public int hashCode() {
        return this.name.hashCode() * 31 + this.grid.hashCode();
    }

    record ModInformation(String name, String version) {
        public static final MapCodec<ModInformation> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf(Spell.TAG_MOD_NAME).forGetter(ModInformation::name), (App)Codec.STRING.fieldOf(Spell.TAG_MOD_VERSION).forGetter(ModInformation::version)).apply((Applicative)instance, ModInformation::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ModInformation> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, ModInformation::name, (StreamCodec)ByteBufCodecs.STRING_UTF8, ModInformation::version, ModInformation::new);
    }
}

