/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.items.armors;

import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.menu.MenuOpener;
import appeng.menu.locator.ItemMenuHostLocator;
import appeng.menu.locator.MenuHostLocator;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.network.PacketDistributor;
import net.pedroksl.advanced_ae.client.renderer.QuantumArmorRenderer;
import net.pedroksl.advanced_ae.common.definitions.AAEMaterials;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.common.helpers.PortableCellWorkbenchMenuHost;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import net.pedroksl.advanced_ae.common.items.upgrades.QuantumUpgradeBaseItem;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.advanced_ae.network.packet.MenuSelectionPacket;
import net.pedroksl.advanced_ae.xmod.iris.IrisPlugin;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;

public class QuantumHelmet
extends QuantumArmorBase {
    private static final double MAX_POWER_STORAGE = 2.0E8;

    public QuantumHelmet(Item.Properties properties) {
        super((Holder<ArmorMaterial>)AAEMaterials.QUANTUM_ALLOY.material(), ArmorItem.Type.HELMET, properties, () -> 2.0E8);
        this.registerUpgrades(UpgradeType.WATER_BREATHING, UpgradeType.AUTO_FEED, UpgradeType.AUTO_STOCK, UpgradeType.MAGNET, UpgradeType.LUCK, UpgradeType.NIGHT_VISION, UpgradeType.CHARGING, UpgradeType.WORKBENCH, UpgradeType.CAMO);
    }

    @Override
    public void tick(ItemStack stack, Level level, Entity entity, int slotId) {
        if (slotId == 36 + EquipmentSlot.HEAD.getIndex() && entity instanceof Player) {
            Player player = (Player)entity;
            if (!this.getPassiveUpgrades(stack).isEmpty()) {
                this.tickUpgrades(level, player, stack);
            }
            if (this.isVisible(stack)) {
                this.toggleBoneVisibilities(stack, player);
            }
        }
    }

    private void toggleBoneVisibilities(ItemStack stack, Player player) {
        GeoRenderProvider provider;
        HumanoidModel renderer;
        QuantumArmorBase item = (QuantumArmorBase)stack.getItem();
        Object renderProvider = item.getRenderProvider();
        if (renderProvider instanceof GeoRenderProvider && (renderer = (provider = (GeoRenderProvider)renderProvider).getGeoArmorRenderer((LivingEntity)player, stack, EquipmentSlot.HEAD, null)) instanceof QuantumArmorRenderer) {
            QuantumArmorRenderer quantumRenderer = (QuantumArmorRenderer)renderer;
            boolean visible = IrisPlugin.isShaderPackInUse();
            quantumRenderer.setBoneVisible("hud", visible);
        }
    }

    @Override
    public boolean openFromEquipmentSlot(Player player, ItemMenuHostLocator locator, boolean returningFromSubmenu) {
        ItemStack is = locator.locateItem(player);
        if (!player.level().isClientSide() && this.checkPreconditions(is)) {
            player.getPersistentData().putInt("aae$menutype", QuantumArmorBase.MenuId.STANDARD.id);
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new MenuSelectionPacket("aae$menutype", QuantumArmorBase.MenuId.STANDARD.id), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return super.openFromEquipmentSlot(player, locator, returningFromSubmenu);
    }

    public boolean openPortableWorkbench(Player player, ItemMenuHostLocator locator) {
        return this.openPortableWorkbench(player, locator, false);
    }

    public boolean openPortableWorkbench(Player player, ItemMenuHostLocator locator, boolean returningFromSubmenu) {
        ItemStack is = locator.locateItem(player);
        if (!player.level().isClientSide() && this.checkPreconditions(is)) {
            if (((QuantumHelmet)is.getItem()).isUpgradeEnabled(is, UpgradeType.WORKBENCH)) {
                player.getPersistentData().putInt("aae$menutype", QuantumArmorBase.MenuId.WORKBENCH.id);
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new MenuSelectionPacket("aae$menutype", QuantumArmorBase.MenuId.WORKBENCH.id), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return MenuOpener.open(AAEMenus.PORTABLE_WORKBENCH.get(), (Player)player, (MenuHostLocator)locator, (boolean)returningFromSubmenu);
            }
            MutableComponent id = Component.translatable((String)((QuantumUpgradeBaseItem)UpgradeType.WORKBENCH.item().asItem()).getDescriptionId());
            player.displayClientMessage((Component)AAEText.UpgradeNotInstalledMessage.text(new Object[]{id}), true);
        }
        return false;
    }

    @Override
    public ItemMenuHost<?> getMenuHost(Player player, ItemMenuHostLocator locator, @Nullable BlockHitResult hitResult) {
        if (player.getPersistentData().contains("aae$menutype") && player.getPersistentData().getInt("aae$menutype") == QuantumArmorBase.MenuId.WORKBENCH.id) {
            player.getPersistentData().remove("aae$menutype");
            return new PortableCellWorkbenchMenuHost(this, player, locator);
        }
        player.getPersistentData().remove("aae$menutype");
        return super.getMenuHost(player, locator, hitResult);
    }
}

