/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.facet.facetset;

import guideme.internal.shaded.lucene.document.IntPoint;
import guideme.internal.shaded.lucene.facet.facetset.FacetSet;
import java.util.Arrays;

public class IntFacetSet
extends FacetSet {
    public final int[] values;

    public IntFacetSet(int ... values) {
        super(IntFacetSet.validateValuesAndGetNumDims(values));
        this.values = values;
    }

    @Override
    public long[] getComparableValues() {
        return Arrays.stream(this.values).mapToLong(Long::valueOf).toArray();
    }

    @Override
    public int packValues(byte[] buf, int start) {
        int i = 0;
        int offset = start;
        while (i < this.values.length) {
            IntPoint.encodeDimension(this.values[i], buf, offset);
            ++i;
            offset += 4;
        }
        return this.values.length * 4;
    }

    @Override
    public int sizePackedBytes() {
        return this.dims * 4;
    }

    private static int validateValuesAndGetNumDims(int ... values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("values cannot be null or empty");
        }
        return values.length;
    }
}

