/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.client.particle;

import com.stal111.forbidden_arcanus.client.particle.EssenceDropParticleOption;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class EssenceDropParticle
extends TextureSheetParticle {
    private static final float SPEED = 0.07f;
    private final List<Vector3f> path;
    private int currentPathIndex = 0;
    private float progress = 0.0f;

    protected EssenceDropParticle(ClientLevel level, double x, double y, double z, List<Vector3f> path) {
        super(level, x, y, z);
        this.path = path;
        this.hasPhysics = false;
        this.setLifetime(30);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.currentPathIndex >= this.path.size()) {
            this.remove();
        } else {
            Vector3f currentPos = this.path.get(this.currentPathIndex);
            Vector3f nextPos = this.path.get(Math.min(this.currentPathIndex + 1, this.path.size() - 1));
            this.x = currentPos.x() + (nextPos.x() - currentPos.x()) * this.progress;
            this.y = currentPos.y() + (nextPos.y() - currentPos.y()) * this.progress;
            this.z = currentPos.z() + (nextPos.z() - currentPos.z()) * this.progress;
            this.progress += 0.07f;
            if (this.progress >= 1.0f) {
                this.progress = 0.0f;
                ++this.currentPathIndex;
            }
        }
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public record Provider(SpriteSet spriteSet) implements ParticleProvider<EssenceDropParticleOption>
    {
        public Particle createParticle(@NotNull EssenceDropParticleOption type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            EssenceDropParticle particle = new EssenceDropParticle(level, x, y, z, type.path());
            particle.pickSprite(this.spriteSet);
            return particle;
        }
    }
}

