/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature.structure.jigsaw;

import com.bobmowzie.mowziesmobs.server.world.feature.structure.jigsaw.MowzieJigsawManager;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class MowziePoolElement
extends SinglePoolElement {
    public static final MapCodec<MowziePoolElement> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)MowziePoolElement.templateCodec(), (App)MowziePoolElement.processorsCodec(), (App)MowziePoolElement.projectionCodec(), (App)BoundsParams.CODEC.optionalFieldOf("bounds", (Object)new BoundsParams(false, BlockPos.ZERO, BlockPos.ZERO, BlockPos.ZERO, Optional.empty(), Optional.empty(), Optional.empty(), BlockPos.ZERO, BlockPos.ZERO, true, false, Optional.empty(), Optional.empty())).forGetter(element -> element.bounds), (App)ConditionsParams.CODEC.optionalFieldOf("conditions", (Object)new ConditionsParams(-1, -1, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Collections.emptyList(), 1)).forGetter(element -> element.conditions), (App)TagsParams.CODEC.optionalFieldOf("tags", (Object)new TagsParams(Collections.emptyList(), false, Optional.empty(), 1)).forGetter(element -> element.tags), (App)Codec.BOOL.optionalFieldOf("two_way", (Object)false).forGetter(element -> element.twoWay), (App)Codec.INT.optionalFieldOf("gen_order", (Object)0).forGetter(element -> element.genOrder), (App)Codec.INT.optionalFieldOf("priority", (Object)0).forGetter(element -> element.priority)).apply((Applicative)builder, MowziePoolElement::new));
    public final BoundsParams bounds;
    public final ConditionsParams conditions;
    public final TagsParams tags;
    public final boolean twoWay;
    public final int genOrder;
    public final int priority;

    protected MowziePoolElement(Either<ResourceLocation, StructureTemplate> p_210415_, Holder<StructureProcessorList> p_210416_, StructureTemplatePool.Projection p_210417_, BoundsParams bounds, ConditionsParams conditions, TagsParams tags, boolean twoWay, int genOrder, int priority) {
        super(p_210415_, p_210416_, p_210417_, Optional.of(LiquidSettings.IGNORE_WATERLOGGING));
        this.bounds = bounds;
        this.conditions = conditions;
        this.tags = tags;
        this.twoWay = twoWay;
        this.genOrder = genOrder;
        this.priority = priority;
    }

    public static boolean canAttachTwoWays(StructureTemplate.StructureBlockInfo p_54246_, StructureTemplate.StructureBlockInfo p_54247_) {
        Direction direction = JigsawBlock.getFrontFacing((BlockState)p_54246_.state());
        Direction direction1 = JigsawBlock.getFrontFacing((BlockState)p_54247_.state());
        Direction direction2 = JigsawBlock.getTopFacing((BlockState)p_54246_.state());
        Direction direction3 = JigsawBlock.getTopFacing((BlockState)p_54247_.state());
        JigsawBlockEntity.JointType jigsawblockentity$jointtype = JigsawBlockEntity.JointType.byName((String)p_54246_.nbt().getString("joint")).orElseGet(() -> direction.getAxis().isHorizontal() ? JigsawBlockEntity.JointType.ALIGNED : JigsawBlockEntity.JointType.ROLLABLE);
        boolean flag = jigsawblockentity$jointtype == JigsawBlockEntity.JointType.ROLLABLE;
        return direction == direction1 && (flag || direction2 == direction3) && p_54246_.nbt().getString("target").equals(p_54247_.nbt().getString("name"));
    }

    public boolean ignoresBounds() {
        return this.bounds.ignoreBounds;
    }

    public boolean placeBounds() {
        return this.bounds.placeBounds;
    }

    public boolean twoWay() {
        return this.twoWay;
    }

    public Vec3i offset() {
        return new Vec3i(this.bounds.offset.getX(), this.bounds.offset.getY(), this.bounds.offset.getZ());
    }

    public boolean checkCriteria(MowzieJigsawManager.PieceState pieceState, MowzieJigsawManager.Placer placer) {
        int maxDepth = this.conditions.maxDepth;
        if (maxDepth != -1 && pieceState.depth > maxDepth) {
            return false;
        }
        int minDepth = this.conditions.minDepth;
        if (minDepth != -1 && pieceState.depth < minDepth) {
            return false;
        }
        MowzieJigsawManager.PieceState parent = pieceState;
        for (int i = 0; i < this.conditions.forbiddenParentsDepth && parent != null; ++i) {
            String parentName = parent.piece.getElement().toString().split("[\\[\\]]")[2];
            if (this.conditions.forbiddenParents.contains(parentName)) {
                return false;
            }
            parent = parent.parent;
        }
        if (this.tags.needsTag.isPresent()) {
            parent = pieceState;
            boolean foundTag = false;
            for (int i = 0; i < this.tags.needsTagDepth; ++i) {
                if (this.tags.needsTag.get().equals(parent.tag)) {
                    foundTag = true;
                    break;
                }
                parent = parent.parent;
            }
            if (!foundTag) {
                return false;
            }
        }
        if (!(placer instanceof MowzieJigsawManager.FallbackPlacer)) {
            if (this.conditions.minRequiredPaths.isPresent() && placer.numPaths < this.conditions.minRequiredPaths.get()) {
                return false;
            }
            if (this.conditions.maxAllowedPaths.isPresent() && placer.numPaths > this.conditions.maxAllowedPaths.get()) {
                return false;
            }
        }
        return true;
    }

    public String getRandomTag(RandomSource random) {
        if (this.tags.tags.isEmpty()) {
            return null;
        }
        int total = 0;
        for (Tag tag : this.tags.tags) {
            total += tag.weight;
        }
        float rand = random.nextFloat() * (float)total;
        total = 0;
        for (Tag tag : this.tags.tags) {
            if (!((float)(total += tag.weight) >= rand)) continue;
            return tag.tag;
        }
        return null;
    }

    public BoundingBox getBoundingBox(StructureTemplateManager structureManager, BlockPos blockPos, Rotation rotation) {
        StructureTemplate structuretemplate = this.getTemplate(structureManager);
        Vec3i sizeVec = structuretemplate.getSize().offset(-1, -1, -1);
        BlockPos blockpos = StructureTemplate.transform((BlockPos)BlockPos.ZERO.offset((Vec3i)this.bounds.boundsMinOffset), (Mirror)Mirror.NONE, (Rotation)rotation, (BlockPos)BlockPos.ZERO);
        BlockPos blockpos1 = StructureTemplate.transform((BlockPos)BlockPos.ZERO.offset(sizeVec).offset((Vec3i)this.bounds.boundsMaxOffset), (Mirror)Mirror.NONE, (Rotation)rotation, (BlockPos)BlockPos.ZERO);
        return BoundingBox.fromCorners((Vec3i)blockpos, (Vec3i)blockpos1).move((Vec3i)blockPos);
    }

    public BoundingBox getCheckBoundingBox(StructureTemplateManager structureManager, BlockPos blockPos, Rotation rotation) {
        StructureTemplate structuretemplate = this.getTemplate(structureManager);
        Vec3i sizeVec = structuretemplate.getSize().offset(-1, -1, -1);
        BlockPos blockpos = StructureTemplate.transform((BlockPos)BlockPos.ZERO.offset((Vec3i)this.bounds.boundsMinOffset).offset((Vec3i)this.bounds.checkBoundsMinOffset), (Mirror)Mirror.NONE, (Rotation)rotation, (BlockPos)BlockPos.ZERO);
        BlockPos blockpos1 = StructureTemplate.transform((BlockPos)BlockPos.ZERO.offset(sizeVec).offset((Vec3i)this.bounds.boundsMaxOffset).offset((Vec3i)this.bounds.checkBoundsMaxOffset), (Mirror)Mirror.NONE, (Rotation)rotation, (BlockPos)BlockPos.ZERO);
        return BoundingBox.fromCorners((Vec3i)blockpos, (Vec3i)blockpos1).move((Vec3i)blockPos);
    }

    public BoundingBox getInteriorBoundingBox(StructureTemplateManager structureManager, BlockPos blockPos, Rotation rotation) {
        if (this.bounds.interiorBoundsMaxOffset.isEmpty() && this.bounds.interiorBoundsMinOffset.isEmpty()) {
            return null;
        }
        BlockPos interiorBoundsMinOffset = BlockPos.ZERO;
        BlockPos interiorBoundsMaxOffset = BlockPos.ZERO;
        if (this.bounds.interiorBoundsMinOffset.isPresent()) {
            interiorBoundsMinOffset = this.bounds.interiorBoundsMinOffset.get();
        }
        if (this.bounds.interiorBoundsMaxOffset.isPresent()) {
            interiorBoundsMaxOffset = this.bounds.interiorBoundsMaxOffset.get();
        }
        StructureTemplate structuretemplate = this.getTemplate(structureManager);
        Vec3i sizeVec = structuretemplate.getSize().offset(-1, -1, -1);
        BlockPos blockpos = StructureTemplate.transform((BlockPos)BlockPos.ZERO.offset((Vec3i)this.bounds.boundsMinOffset).offset((Vec3i)interiorBoundsMinOffset), (Mirror)Mirror.NONE, (Rotation)rotation, (BlockPos)BlockPos.ZERO);
        BlockPos blockpos1 = StructureTemplate.transform((BlockPos)BlockPos.ZERO.offset(sizeVec).offset((Vec3i)this.bounds.boundsMaxOffset).offset((Vec3i)interiorBoundsMaxOffset), (Mirror)Mirror.NONE, (Rotation)rotation, (BlockPos)BlockPos.ZERO);
        return BoundingBox.fromCorners((Vec3i)blockpos, (Vec3i)blockpos1).move((Vec3i)blockPos);
    }

    public static class BoundsParams {
        public static final Codec<BoundsParams> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.optionalFieldOf("ignore_bounds", (Object)false).forGetter(element -> element.ignoreBounds), (App)BlockPos.CODEC.optionalFieldOf("bounds_min_offset", (Object)BlockPos.ZERO).forGetter(element -> element.boundsMinOffset), (App)BlockPos.CODEC.optionalFieldOf("bounds_max_offset", (Object)BlockPos.ZERO).forGetter(element -> element.boundsMaxOffset), (App)BlockPos.CODEC.optionalFieldOf("offset", (Object)BlockPos.ZERO).forGetter(element -> element.offset), (App)Codec.STRING.optionalFieldOf("special_bounds").forGetter(element -> element.specialBounds), (App)Codec.STRING.optionalFieldOf("needs_overlap_bounds").forGetter(element -> element.needsOverlapBounds), (App)Codec.STRING.optionalFieldOf("forbidden_overlap_bounds").forGetter(element -> element.forbiddenOverlapBounds), (App)BlockPos.CODEC.optionalFieldOf("check_bounds_min_offset", (Object)BlockPos.ZERO).forGetter(element -> element.checkBoundsMinOffset), (App)BlockPos.CODEC.optionalFieldOf("check_bounds_max_offset", (Object)BlockPos.ZERO).forGetter(element -> element.checkBoundsMaxOffset), (App)Codec.BOOL.optionalFieldOf("place_bounds", (Object)true).forGetter(element -> element.placeBounds), (App)Codec.BOOL.optionalFieldOf("ignore_parent_bounds", (Object)false).forGetter(element -> element.ignoreParentBounds), (App)BlockPos.CODEC.optionalFieldOf("interior_bounds_min_offset").forGetter(element -> element.interiorBoundsMinOffset), (App)BlockPos.CODEC.optionalFieldOf("interior_bounds_max_offset").forGetter(element -> element.interiorBoundsMaxOffset)).apply((Applicative)builder, BoundsParams::new));
        public final boolean ignoreBounds;
        public final BlockPos boundsMinOffset;
        public final BlockPos boundsMaxOffset;
        public final BlockPos offset;
        public final Optional<String> specialBounds;
        public final Optional<String> needsOverlapBounds;
        public final Optional<String> forbiddenOverlapBounds;
        public final BlockPos checkBoundsMinOffset;
        public final BlockPos checkBoundsMaxOffset;
        public final boolean placeBounds;
        public final boolean ignoreParentBounds;
        public final Optional<BlockPos> interiorBoundsMinOffset;
        public final Optional<BlockPos> interiorBoundsMaxOffset;

        private BoundsParams(boolean ignoreBounds, BlockPos boundsMinOffset, BlockPos boundsMaxOffset, BlockPos offset, Optional<String> specialBounds, Optional<String> needsOverlapBounds, Optional<String> forbiddenOverlapBounds, BlockPos checkBoundsMinOffset, BlockPos checkBoundsMaxOffset, boolean placeBounds, boolean ignoreParentBounds, Optional<BlockPos> interiorBoundsMinOffset, Optional<BlockPos> interiorBoundsMaxOffset) {
            this.ignoreBounds = ignoreBounds;
            this.boundsMinOffset = boundsMinOffset;
            this.boundsMaxOffset = boundsMaxOffset;
            this.offset = offset;
            this.specialBounds = specialBounds;
            this.forbiddenOverlapBounds = forbiddenOverlapBounds;
            this.needsOverlapBounds = needsOverlapBounds;
            this.checkBoundsMinOffset = checkBoundsMinOffset;
            this.checkBoundsMaxOffset = checkBoundsMaxOffset;
            this.placeBounds = placeBounds;
            this.ignoreParentBounds = ignoreParentBounds;
            this.interiorBoundsMinOffset = interiorBoundsMinOffset;
            this.interiorBoundsMaxOffset = interiorBoundsMaxOffset;
        }
    }

    public static class ConditionsParams {
        public static final Codec<ConditionsParams> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.optionalFieldOf("min_depth", (Object)-1).forGetter(element -> element.minDepth), (App)Codec.INT.optionalFieldOf("max_depth", (Object)-1).forGetter(element -> element.maxDepth), (App)Codec.INT.optionalFieldOf("min_height").forGetter(element -> element.minHeight), (App)Codec.INT.optionalFieldOf("max_height").forGetter(element -> element.maxHeight), (App)Codec.INT.optionalFieldOf("min_required_paths").forGetter(element -> element.minRequiredPaths), (App)Codec.INT.optionalFieldOf("max_allowed_paths").forGetter(element -> element.maxAllowedPaths), (App)Codec.INT.optionalFieldOf("num_paths_override").forGetter(element -> element.numPathsOverride), (App)Codec.STRING.listOf().optionalFieldOf("forbidden_parents", Collections.emptyList()).forGetter(element -> element.forbiddenParents), (App)Codec.INT.optionalFieldOf("forbidden_parents_depth", (Object)1).forGetter(element -> element.forbiddenParentsDepth)).apply((Applicative)builder, ConditionsParams::new));
        public final int minDepth;
        public final int maxDepth;
        public final Optional<Integer> minHeight;
        public final Optional<Integer> maxHeight;
        public final Optional<Integer> minRequiredPaths;
        public final Optional<Integer> maxAllowedPaths;
        public final Optional<Integer> numPathsOverride;
        public final List<String> forbiddenParents;
        public final int forbiddenParentsDepth;

        private ConditionsParams(int minDepth, int maxDepth, Optional<Integer> minHeight, Optional<Integer> maxHeight, Optional<Integer> minRequiredPaths, Optional<Integer> maxAllowedPaths, Optional<Integer> numPathsOverride, List<String> forbiddenParents, int forbiddenParentsDepth) {
            this.minDepth = minDepth;
            this.maxDepth = maxDepth;
            this.minHeight = minHeight;
            this.maxHeight = maxHeight;
            this.minRequiredPaths = minRequiredPaths;
            this.maxAllowedPaths = maxAllowedPaths;
            this.numPathsOverride = numPathsOverride;
            this.forbiddenParents = forbiddenParents;
            this.forbiddenParentsDepth = forbiddenParentsDepth;
        }
    }

    public static class TagsParams {
        public static final Codec<TagsParams> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Tag.CODEC.listOf().optionalFieldOf("possible_tags", Collections.emptyList()).forGetter(element -> element.tags), (App)Codec.BOOL.optionalFieldOf("inherits_tag", (Object)false).forGetter(element -> element.inheritsTag), (App)Codec.STRING.optionalFieldOf("needs_tag").forGetter(element -> element.needsTag), (App)Codec.INT.optionalFieldOf("needs_tag_depth", (Object)1).forGetter(element -> element.needsTagDepth)).apply((Applicative)builder, TagsParams::new));
        public final List<Tag> tags;
        public final boolean inheritsTag;
        public final Optional<String> needsTag;
        public final int needsTagDepth;

        private TagsParams(List<Tag> tags, boolean inheritsTag, Optional<String> needsTag, int needsTagDepth) {
            this.tags = tags;
            this.inheritsTag = inheritsTag;
            this.needsTag = needsTag;
            this.needsTagDepth = needsTagDepth;
        }
    }

    public record Tag(String tag, int weight) {
        public static final Codec<Tag> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("tag").forGetter(element -> element.tag), (App)Codec.INT.optionalFieldOf("weight", (Object)1).forGetter(element -> element.weight)).apply((Applicative)builder, Tag::new));
    }
}

