/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects;

import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.ParticleVanillaCloudExtended;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityMagicEffect;
import com.bobmowzie.mowziesmobs.server.entity.naga.EntityNaga;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityPoisonBall
extends EntityMagicEffect {
    private static final byte EXPLOSION_PARTICLES_ID = 69;
    public static float GRAVITY = 0.05f;
    public double prevMotionX;
    public double prevMotionY;
    public double prevMotionZ;

    public EntityPoisonBall(EntityType<? extends EntityPoisonBall> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntityPoisonBall(EntityType<? extends EntityPoisonBall> type, Level worldIn, LivingEntity caster) {
        super(type, worldIn, caster);
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        this.setDeltaMovement(x * (double)velocity, y * (double)velocity, z * (double)velocity);
    }

    @Override
    public void tick() {
        this.prevMotionX = this.getDeltaMovement().x;
        this.prevMotionY = this.getDeltaMovement().y;
        this.prevMotionZ = this.getDeltaMovement().z;
        super.tick();
        this.setDeltaMovement(this.getDeltaMovement().subtract(0.0, (double)GRAVITY, 0.0));
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.setYRot(-((float)Mth.atan2((double)this.getDeltaMovement().x, (double)this.getDeltaMovement().z)) * 57.295776f);
        List<Entity> entitiesHit = this.getEntitiesNearby(1.0);
        if (!entitiesHit.isEmpty()) {
            for (Entity entity : entitiesHit) {
                if (entity instanceof ItemEntity || entity == this.getCaster() || entity instanceof EntityNaga || entity instanceof ItemEntity || !entity.hurt(this.damageSources().indirectMagic((Entity)this, (Entity)this.getCaster()), 3.0f * ((Double)ConfigHandler.COMMON.MOBS.NAGA.combatConfig.attackMultiplier.get()).floatValue()) || !(entity instanceof LivingEntity)) continue;
                ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.POISON, 80, 1, false, true));
            }
        }
        if (!this.level().noCollision((Entity)this, this.getBoundingBox().inflate(0.1))) {
            this.explode();
        }
        if (this.level().isClientSide) {
            float scale = 1.0f;
            int steps = 4;
            double motionX = this.getDeltaMovement().x;
            double motionY = this.getDeltaMovement().y;
            double motionZ = this.getDeltaMovement().z;
            for (int step = 0; step < steps; ++step) {
                double life;
                double value;
                double zSpeed;
                double ySpeed;
                double xSpeed;
                int i;
                double x = this.xo + (double)step * (this.getX() - this.xo) / (double)steps;
                double y = this.yo + (double)step * (this.getY() - this.yo) / (double)steps + (double)(this.getBbHeight() / 2.0f);
                double z = this.zo + (double)step * (this.getZ() - this.zo) / (double)steps;
                for (i = 0; i < 1; ++i) {
                    xSpeed = (double)scale * 0.02 * (double)(this.random.nextFloat() * 2.0f - 1.0f);
                    ySpeed = (double)scale * 0.02 * (double)(this.random.nextFloat() * 2.0f - 1.0f);
                    zSpeed = (double)scale * 0.02 * (double)(this.random.nextFloat() * 2.0f - 1.0f);
                    value = this.random.nextFloat() * 0.1f;
                    life = this.random.nextFloat() * 10.0f + 15.0f;
                    ParticleVanillaCloudExtended.spawnVanillaCloud(this.level(), x - motionX * 0.5, y - motionY * 0.5, z - motionZ * 0.5, xSpeed, ySpeed, zSpeed, scale, 0.25 + value, 0.75 + value, 0.25 + value, 0.99, life);
                }
                for (i = 0; i < 2; ++i) {
                    xSpeed = (double)scale * 0.06 * (double)(this.random.nextFloat() * 2.0f - 1.0f);
                    ySpeed = (double)scale * 0.06 * (double)(this.random.nextFloat() * 2.0f - 1.0f);
                    zSpeed = (double)scale * 0.06 * (double)(this.random.nextFloat() * 2.0f - 1.0f);
                    value = this.random.nextFloat() * 0.1f;
                    life = this.random.nextFloat() * 5.0f + 10.0f;
                    AdvancedParticleBase.spawnParticle(this.level(), ParticleHandler.PIXEL, x + xSpeed - motionX * 0.5, y + ySpeed - motionY * 0.5, z + zSpeed - motionZ * 0.5, xSpeed, ySpeed, zSpeed, true, 0.0, 0.0, 0.0, 0.0, scale * 3.0f, 0.07 + value, 0.25 + value, 0.07 + value, 1.0, 0.99, life * 0.9, false, true);
                }
                for (i = 0; i < 1; ++i) {
                    if (!(this.random.nextFloat() < 0.9f)) continue;
                    xSpeed = (double)scale * 0.06 * (double)(this.random.nextFloat() * 2.0f - 1.0f);
                    ySpeed = (double)scale * 0.06 * (double)(this.random.nextFloat() * 2.0f - 1.0f);
                    zSpeed = (double)scale * 0.06 * (double)(this.random.nextFloat() * 2.0f - 1.0f);
                    value = this.random.nextFloat() * 0.1f;
                    life = this.random.nextFloat() * 5.0f + 10.0f;
                    AdvancedParticleBase.spawnParticle(this.level(), ParticleHandler.BUBBLE, x - motionX * 0.5, y - motionY * 0.5, z - motionZ * 0.5, xSpeed, ySpeed, zSpeed, true, 0.0, 0.0, 0.0, 0.0, 3.0, 0.25 + value, 0.75 + value, 0.25 + value, 1.0, 0.85, life, false, true);
                }
            }
        }
        if (this.tickCount > 50) {
            this.discard();
        }
    }

    private void explode() {
        this.level().broadcastEntityEvent((Entity)this, (byte)69);
        this.playSound((SoundEvent)MMSounds.ENTITY_NAGA_ACID_HIT.get(), 1.0f, 1.0f);
        List<Entity> entitiesHit = this.getEntitiesNearby(2.0);
        if (!entitiesHit.isEmpty()) {
            for (Entity entity : entitiesHit) {
                if (entity == this.getCaster() || entity instanceof EntityNaga || !entity.hurt(this.damageSources().indirectMagic((Entity)this, (Entity)this.getCaster()), 3.0f * ((Double)ConfigHandler.COMMON.MOBS.NAGA.combatConfig.attackMultiplier.get()).floatValue()) || !(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.addEffect(new MobEffectInstance(MobEffects.POISON, 80, 0, false, true));
            }
        }
        this.discard();
    }

    private void spawnExplosionParticles() {
        if (this.level().isClientSide) {
            double life;
            double value;
            Vec3 particlePos;
            int i;
            float explodeSpeed = 3.5f;
            for (i = 0; i < 26; ++i) {
                particlePos = new Vec3((double)this.random.nextFloat() * 0.25, 0.0, 0.0);
                particlePos = particlePos.yRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
                particlePos = particlePos.xRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
                value = this.random.nextFloat() * 0.1f;
                life = this.random.nextFloat() * 17.0f + 30.0f;
                ParticleVanillaCloudExtended.spawnVanillaCloud(this.level(), this.getX(), this.getY(), this.getZ(), particlePos.x * (double)explodeSpeed, particlePos.y * (double)explodeSpeed, particlePos.z * (double)explodeSpeed, 1.0, 0.25 + value, 0.75 + value, 0.25 + value, 0.6, life);
            }
            for (i = 0; i < 26; ++i) {
                particlePos = new Vec3((double)this.random.nextFloat() * 0.25, 0.0, 0.0);
                particlePos = particlePos.yRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
                particlePos = particlePos.xRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
                value = this.random.nextFloat() * 0.1f;
                life = this.random.nextFloat() * 5.0f + 10.0f;
                AdvancedParticleBase.spawnParticle(this.level(), ParticleHandler.PIXEL, this.getX() + particlePos.x, this.getY() + particlePos.y, this.getZ() + particlePos.z, particlePos.x * (double)explodeSpeed, particlePos.y * (double)explodeSpeed, particlePos.z * (double)explodeSpeed, true, 0.0, 0.0, 0.0, 0.0, 3.0, 0.07 + value, 0.25 + value, 0.07 + value, 1.0, 0.6, life * 0.95, false, true);
            }
            for (i = 0; i < 23; ++i) {
                particlePos = new Vec3((double)this.random.nextFloat() * 0.25, 0.0, 0.0);
                particlePos = particlePos.yRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
                particlePos = particlePos.xRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
                value = this.random.nextFloat() * 0.1f;
                life = this.random.nextFloat() * 10.0f + 20.0f;
                AdvancedParticleBase.spawnParticle(this.level(), ParticleHandler.BUBBLE, this.getX() + particlePos.x, this.getY() + particlePos.y, this.getZ() + particlePos.z, particlePos.x * (double)explodeSpeed, particlePos.y * (double)explodeSpeed, particlePos.z * (double)explodeSpeed, true, 0.0, 0.0, 0.0, 0.0, 3.0, 0.25 + value, 0.75 + value, 0.25 + value, 1.0, 0.6, life * 0.95, false, true);
            }
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 69) {
            this.spawnExplosionParticles();
        } else {
            super.handleEntityEvent(id);
        }
    }
}

