/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects;

import com.bobmowzie.mowziesmobs.MMCommon;
import com.bobmowzie.mowziesmobs.client.particle.ParticleCloud;
import com.bobmowzie.mowziesmobs.client.particle.ParticleRing;
import com.bobmowzie.mowziesmobs.client.particle.ParticleSnowFlake;
import com.bobmowzie.mowziesmobs.server.capability.DataHandler;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityMagicEffect;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityIceBall
extends EntityMagicEffect {
    public EntityIceBall(Level world) {
        super((EntityType<? extends EntityMagicEffect>)((EntityType)EntityHandler.ICE_BALL.get()), world);
    }

    public EntityIceBall(EntityType<? extends EntityIceBall> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntityIceBall(EntityType<? extends EntityIceBall> type, Level worldIn, LivingEntity caster) {
        super(type, worldIn, caster);
    }

    @Override
    public void tick() {
        List<Entity> entitiesHit;
        super.tick();
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (this.tickCount == 1 && this.level().isClientSide) {
            MMCommon.PROXY.playIceBreathSound(this);
        }
        if (!(entitiesHit = this.getEntitiesNearby(2.0)).isEmpty()) {
            for (Entity entity : entitiesHit) {
                if (entity instanceof ItemEntity || entity == this.getCaster() || entity instanceof ItemEntity || entity.getType().is(EntityTypeTags.FREEZE_IMMUNE_ENTITY_TYPES) || entity instanceof EnderDragon || !entity.hurt(this.damageSources().freeze(), 3.0f * ((Double)ConfigHandler.COMMON.MOBS.FROSTMAW.combatConfig.attackMultiplier.get()).floatValue()) || !(entity instanceof LivingEntity)) continue;
                DataHandler.getData(entity, DataHandler.FROZEN_DATA).addFreezeProgress((LivingEntity)entity, 1.0f);
            }
        }
        if (!this.level().noCollision((Entity)this, this.getBoundingBox().inflate(0.15))) {
            this.explode();
        }
        if (this.level().isClientSide) {
            double zSpeed;
            double ySpeed;
            double xSpeed;
            int i;
            float scale = 2.0f;
            double x = this.getX();
            double y = this.getY() + (double)(this.getBbHeight() / 2.0f);
            double z = this.getZ();
            double motionX = this.getDeltaMovement().x;
            double motionY = this.getDeltaMovement().y;
            double motionZ = this.getDeltaMovement().z;
            for (i = 0; i < 4; ++i) {
                xSpeed = (double)scale * 0.01 * (double)(this.random.nextFloat() * 2.0f - 1.0f);
                ySpeed = (double)scale * 0.01 * (double)(this.random.nextFloat() * 2.0f - 1.0f);
                zSpeed = (double)scale * 0.01 * (double)(this.random.nextFloat() * 2.0f - 1.0f);
                float value = this.random.nextFloat() * 0.15f;
                this.level().addParticle((ParticleOptions)new ParticleCloud.Data(0.75f + value, 0.75f + value, 1.0f, scale * (10.0f + this.random.nextFloat() * 20.0f), 20, ParticleCloud.EnumCloudBehavior.SHRINK, 1.0f), x + xSpeed, y + ySpeed, z + zSpeed, xSpeed, ySpeed, zSpeed);
            }
            for (i = 0; i < 1; ++i) {
                xSpeed = (double)scale * 0.01 * (double)(this.random.nextFloat() * 2.0f - 1.0f);
                ySpeed = (double)scale * 0.01 * (double)(this.random.nextFloat() * 2.0f - 1.0f);
                zSpeed = (double)scale * 0.01 * (double)(this.random.nextFloat() * 2.0f - 1.0f);
                this.level().addParticle((ParticleOptions)new ParticleCloud.Data(1.0f, 1.0f, 1.0f, scale * (5.0f + this.random.nextFloat() * 10.0f), 40, ParticleCloud.EnumCloudBehavior.SHRINK, 1.0f), x, y, z, xSpeed, ySpeed, zSpeed);
            }
            for (i = 0; i < 5; ++i) {
                xSpeed = (double)scale * 0.05 * (double)(this.random.nextFloat() * 2.0f - 1.0f);
                ySpeed = (double)scale * 0.05 * (double)(this.random.nextFloat() * 2.0f - 1.0f);
                zSpeed = (double)scale * 0.05 * (double)(this.random.nextFloat() * 2.0f - 1.0f);
                this.level().addParticle((ParticleOptions)new ParticleSnowFlake.Data(40.0f, false), x - 20.0 * xSpeed + motionX, y - 20.0 * ySpeed + motionY, z - 20.0 * zSpeed + motionZ, xSpeed, ySpeed, zSpeed);
            }
            float yaw = (float)Math.atan2(motionX, motionZ);
            float pitch = (float)(Math.acos(motionY / Math.sqrt(motionX * motionX + motionY * motionY + motionZ * motionZ)) + 1.5707963267948966);
            if (this.tickCount % 3 == 0) {
                this.level().addParticle((ParticleOptions)new ParticleRing.Data(yaw, pitch, 40.0f, 0.9f, 0.9f, 1.0f, 0.4f, (int)(scale * 16.0f), false, ParticleRing.EnumRingBehavior.GROW_THEN_SHRINK), x + 1.5 * motionX, y + 1.5 * motionY, z + 1.5 * motionZ, 0.0, 0.0, 0.0);
            }
            if (this.tickCount == 1) {
                this.level().addParticle((ParticleOptions)new ParticleRing.Data(yaw, pitch, 20.0f, 0.9f, 0.9f, 1.0f, 0.4f, (int)(scale * 16.0f), false, ParticleRing.EnumRingBehavior.GROW), x, y, z, 0.0, 0.0, 0.0);
            }
        }
        if (this.tickCount > 50) {
            this.discard();
        }
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        this.setDeltaMovement(x * (double)velocity, y * (double)velocity, z * (double)velocity);
    }

    private void explode() {
        if (this.level().isClientSide) {
            Vec3 particlePos;
            int i;
            for (i = 0; i < 8; ++i) {
                particlePos = new Vec3((double)this.random.nextFloat() * 0.3, 0.0, 0.0);
                particlePos = particlePos.yRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
                particlePos = particlePos.xRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
                float value = this.random.nextFloat() * 0.15f;
                this.level().addParticle((ParticleOptions)new ParticleCloud.Data(0.75f + value, 0.75f + value, 1.0f, 10.0f + this.random.nextFloat() * 20.0f, 40, ParticleCloud.EnumCloudBehavior.GROW, 1.0f), this.getX() + particlePos.x, this.getY() + particlePos.y, this.getZ() + particlePos.z, particlePos.x, particlePos.y, particlePos.z);
            }
            for (i = 0; i < 10; ++i) {
                particlePos = new Vec3((double)this.random.nextFloat() * 0.3, 0.0, 0.0);
                particlePos = particlePos.yRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
                particlePos = particlePos.xRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
                this.level().addParticle((ParticleOptions)new ParticleSnowFlake.Data(40.0f, false), this.getX() + particlePos.x, this.getY() + particlePos.y, this.getZ() + particlePos.z, particlePos.x, particlePos.y, particlePos.z);
            }
        }
        this.discard();
    }
}

