/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particle;

import com.bobmowzie.mowziesmobs.client.model.tools.MathUtils;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.render.MMRenderType;
import com.bobmowzie.mowziesmobs.server.message.NetworkHandler;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ParticleRing
extends TextureSheetParticle {
    public float r;
    public float g;
    public float b;
    public float opacity;
    public boolean facesCamera;
    public float yaw;
    public float pitch;
    public float size;
    private final EnumRingBehavior behavior;

    public ParticleRing(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ, float yaw, float pitch, int duration, float r, float g, float b, float opacity, float size, boolean facesCamera, EnumRingBehavior behavior) {
        super(world, x, y, z);
        this.setSize(1.0f, 1.0f);
        this.size = size * 0.1f;
        this.lifetime = duration;
        this.alpha = 1.0f;
        this.r = r;
        this.g = g;
        this.b = b;
        this.opacity = opacity;
        this.yaw = yaw;
        this.pitch = pitch;
        this.facesCamera = facesCamera;
        this.xd = motionX;
        this.yd = motionY;
        this.zd = motionZ;
        this.behavior = behavior;
    }

    public int getLightColor(float delta) {
        return 0xF0 | super.getLightColor(delta) & 0xFF0000;
    }

    public void tick() {
        super.tick();
        if (this.age >= this.lifetime) {
            this.remove();
        }
        ++this.age;
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        float var = ((float)this.age + partialTicks) / (float)this.lifetime;
        this.quadSize = this.behavior == EnumRingBehavior.GROW ? this.size * var : (this.behavior == EnumRingBehavior.SHRINK ? this.size * (1.0f - var) : (this.behavior == EnumRingBehavior.GROW_THEN_SHRINK ? (float)((double)this.size * ((double)(1.0f - var) - Math.pow(2000.0, -var))) : this.size));
        this.alpha = this.opacity * 0.95f * (1.0f - ((float)this.age + partialTicks) / (float)this.lifetime) + 0.05f;
        this.rCol = this.r;
        this.gCol = this.g;
        this.bCol = this.b;
        Vec3 Vector3d2 = renderInfo.getPosition();
        float f = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - Vector3d2.x());
        float f1 = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - Vector3d2.y());
        float f2 = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - Vector3d2.z());
        Quaternionf quaternionf = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
        if (this.facesCamera) {
            if (this.roll == 0.0f) {
                quaternionf = renderInfo.rotation();
            } else {
                quaternionf = new Quaternionf((Quaternionfc)renderInfo.rotation());
                float f3 = Mth.lerp((float)partialTicks, (float)this.oRoll, (float)this.roll);
                quaternionf.mul((Quaternionfc)Axis.ZP.rotation(f3));
            }
        } else {
            Quaternionf quatX = MathUtils.quatFromRotationXYZ(this.pitch, 0.0f, 0.0f, false);
            Quaternionf quatY = MathUtils.quatFromRotationXYZ(0.0f, this.yaw, 0.0f, false);
            quaternionf.mul((Quaternionfc)quatY);
            quaternionf.mul((Quaternionfc)quatX);
        }
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        quaternionf.transform(vector3f1);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.getQuadSize(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            quaternionf.transform(vector3f);
            vector3f.mul(f4);
            vector3f.add(f, f1, f2);
        }
        float f7 = this.getU0();
        float f8 = this.getU1();
        float f5 = this.getV0();
        float f6 = this.getV1();
        int j = this.getLightColor(partialTicks);
        buffer.addVertex(avector3f[0].x(), avector3f[0].y(), avector3f[0].z()).setUv(f8, f6).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
        buffer.addVertex(avector3f[1].x(), avector3f[1].y(), avector3f[1].z()).setUv(f8, f5).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
        buffer.addVertex(avector3f[2].x(), avector3f[2].y(), avector3f[2].z()).setUv(f7, f5).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
        buffer.addVertex(avector3f[3].x(), avector3f[3].y(), avector3f[3].z()).setUv(f7, f6).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
    }

    public ParticleRenderType getRenderType() {
        return MMRenderType.PARTICLE_SHEET_TRANSLUCENT_NO_DEPTH;
    }

    public static enum EnumRingBehavior implements StringRepresentable
    {
        SHRINK("shrink"),
        GROW("grow"),
        CONSTANT("constant"),
        GROW_THEN_SHRINK("grow_then_shrink");

        private final String key;

        private EnumRingBehavior(String key) {
            this.key = key;
        }

        public String getSerializedName() {
            return this.key;
        }
    }

    public record Data(float red, float green, float blue, float alpha, float yaw, float pitch, float scale, int duration, boolean facesCamera, EnumRingBehavior behavior) implements ParticleOptions
    {
        public static final Codec<EnumRingBehavior> BEHAVIOUR_CODEC = StringRepresentable.fromEnum(EnumRingBehavior::values);
        public static final MapCodec<Data> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("red").forGetter(Data::red), (App)Codec.FLOAT.fieldOf("green").forGetter(Data::green), (App)Codec.FLOAT.fieldOf("blue").forGetter(Data::blue), (App)Codec.FLOAT.fieldOf("alpha").forGetter(Data::alpha), (App)Codec.FLOAT.fieldOf("yaw").forGetter(Data::yaw), (App)Codec.FLOAT.fieldOf("pitch").forGetter(Data::pitch), (App)Codec.FLOAT.fieldOf("scale").forGetter(Data::scale), (App)Codec.INT.fieldOf("duration").forGetter(Data::duration), (App)Codec.BOOL.fieldOf("facesCamera").forGetter(Data::facesCamera), (App)BEHAVIOUR_CODEC.fieldOf("behaviour").forGetter(Data::behavior)).apply((Applicative)instance, Data::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC = NetworkHandler.composite(ByteBufCodecs.FLOAT, Data::red, ByteBufCodecs.FLOAT, Data::green, ByteBufCodecs.FLOAT, Data::blue, ByteBufCodecs.FLOAT, Data::alpha, ByteBufCodecs.FLOAT, Data::yaw, ByteBufCodecs.FLOAT, Data::pitch, ByteBufCodecs.FLOAT, Data::scale, ByteBufCodecs.INT, Data::duration, ByteBufCodecs.BOOL, Data::facesCamera, NeoForgeStreamCodecs.enumCodec(EnumRingBehavior.class), Data::behavior, Data::new);

        @NotNull
        public ParticleType<Data> getType() {
            return (ParticleType)ParticleHandler.RING.get();
        }
    }

    public static final class Provider
    implements ParticleProvider<Data> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(Data typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleRing particle = new ParticleRing(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.yaw(), typeIn.pitch(), typeIn.duration(), typeIn.red(), typeIn.green(), typeIn.blue(), typeIn.alpha(), typeIn.scale(), typeIn.facesCamera(), typeIn.behavior());
            particle.setSpriteFromAge(this.spriteSet);
            return particle;
        }
    }
}

