/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particle;

import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.render.MMRenderType;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.jetbrains.annotations.NotNull;

public class ParticleCloud
extends TextureSheetParticle {
    private final float red;
    private final float green;
    private final float blue;
    private final float scale;
    private final EnumCloudBehavior behavior;
    private final float airDrag;

    public ParticleCloud(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, double r, double g, double b, double scale, int duration, EnumCloudBehavior behavior, double airDrag) {
        super(world, x, y, z);
        this.scale = (float)scale * 0.5f * 0.1f;
        this.lifetime = duration;
        this.xd = vx * 0.5;
        this.yd = vy * 0.5;
        this.zd = vz * 0.5;
        this.red = (float)r;
        this.green = (float)g;
        this.blue = (float)b;
        this.behavior = behavior;
        this.roll = this.oRoll = (float)((double)this.random.nextInt(4) * Math.PI / 2.0);
        this.airDrag = (float)airDrag;
    }

    public ParticleRenderType getRenderType() {
        return MMRenderType.PARTICLE_SHEET_TRANSLUCENT_NO_DEPTH;
    }

    public void tick() {
        super.tick();
        this.xd *= (double)this.airDrag;
        this.yd *= (double)this.airDrag;
        this.zd *= (double)this.airDrag;
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        float var = ((float)this.age + partialTicks) / (float)this.lifetime;
        this.alpha = 0.2f * (float)(1.0 - Math.exp(5.0f * (var - 1.0f)) - Math.pow(2000.0, -var));
        if ((double)this.alpha < 0.01) {
            this.alpha = 0.01f;
        }
        this.quadSize = this.behavior == EnumCloudBehavior.SHRINK ? this.scale * (1.0f - 0.7f * var + 0.3f) : (this.behavior == EnumCloudBehavior.GROW ? this.scale * (0.7f * var + 0.3f) : this.scale);
        super.render(buffer, renderInfo, partialTicks);
    }

    public static enum EnumCloudBehavior implements StringRepresentable
    {
        SHRINK("shrink"),
        GROW("grow"),
        CONSTANT("constant");

        private final String key;

        private EnumCloudBehavior(String key) {
            this.key = key;
        }

        @NotNull
        public String getSerializedName() {
            return this.key;
        }
    }

    public record Data(float red, float green, float blue, float scale, int duration, EnumCloudBehavior behavior, float airDrag) implements ParticleOptions
    {
        public static final Codec<EnumCloudBehavior> BEHAVIOUR_CODEC = StringRepresentable.fromEnum(EnumCloudBehavior::values);
        public static final MapCodec<Data> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("red").forGetter(data -> Float.valueOf(data.red)), (App)Codec.FLOAT.fieldOf("green").forGetter(data -> Float.valueOf(data.green)), (App)Codec.FLOAT.fieldOf("blue").forGetter(data -> Float.valueOf(data.blue)), (App)Codec.FLOAT.fieldOf("scale").forGetter(data -> Float.valueOf(data.scale)), (App)Codec.INT.fieldOf("duration").forGetter(data -> data.duration), (App)BEHAVIOUR_CODEC.fieldOf("behaviour").forGetter(data -> data.behavior), (App)Codec.FLOAT.fieldOf("air_drag").forGetter(data -> Float.valueOf(data.airDrag))).apply((Applicative)instance, Data::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC = NeoForgeStreamCodecs.composite((StreamCodec)ByteBufCodecs.FLOAT, Data::red, (StreamCodec)ByteBufCodecs.FLOAT, Data::green, (StreamCodec)ByteBufCodecs.FLOAT, Data::blue, (StreamCodec)ByteBufCodecs.FLOAT, Data::scale, (StreamCodec)ByteBufCodecs.INT, Data::duration, (StreamCodec)NeoForgeStreamCodecs.enumCodec(EnumCloudBehavior.class), Data::behavior, (StreamCodec)ByteBufCodecs.FLOAT, Data::airDrag, Data::new);

        @NotNull
        public ParticleType<?> getType() {
            return (ParticleType)ParticleHandler.CLOUD.value();
        }
    }

    public static final class Provider
    implements ParticleProvider<Data> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(Data typeIn, @NotNull ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleCloud particleCloud = new ParticleCloud(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.red(), typeIn.green(), typeIn.blue(), typeIn.scale(), typeIn.duration(), typeIn.behavior(), typeIn.airDrag());
            particleCloud.setSpriteFromAge(this.spriteSet);
            particleCloud.setColor(typeIn.red(), typeIn.green(), typeIn.blue());
            return particleCloud;
        }
    }
}

