/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.block.otherworld_detector;

import com.simibubi.create.foundation.block.IBE;
import io.github.irishgreencitrus.occultengineering.content.block.otherworld_detector.OtherworldDetectorBlockEntity;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringBlockEntities;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class OtherworldDetectorBlock
extends Block
implements IBE<OtherworldDetectorBlockEntity> {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public OtherworldDetectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{POWERED}));
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public boolean isSignalSource(BlockState state) {
        return (Boolean)state.getValue((Property)POWERED);
    }

    public int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        BlockState toState = level.getBlockState(pos.relative(direction.getOpposite()));
        if (toState.is((Block)this)) {
            return 0;
        }
        if (toState.is(Blocks.COMPARATOR)) {
            OtherworldDetectorBlockEntity be = (OtherworldDetectorBlockEntity)this.getBlockEntity(level, pos);
            if (be == null) {
                return 0;
            }
            return this.isSignalSource(state) ? be.comparatorSignalStrength : 0;
        }
        return this.isSignalSource(state) ? 15 : 0;
    }

    public Class<OtherworldDetectorBlockEntity> getBlockEntityClass() {
        return OtherworldDetectorBlockEntity.class;
    }

    public BlockEntityType<? extends OtherworldDetectorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)OccultEngineeringBlockEntities.OTHERWORLD_DETECTOR.get();
    }
}

