/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.irishgreencitrus.occultengineering.content.entity.brain.DynamicBrain;
import io.github.irishgreencitrus.occultengineering.content.entity.brain.DynamicBrainFactory;
import io.github.irishgreencitrus.occultengineering.content.entity.brain.DynamicBrainSupplantable;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringBrains;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.commands.SummonCommand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class SummonWithBrainCommand {
    static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"summon").requires(cs -> cs.hasPermission(2))).requires(CommandSourceStack::isPlayer)).then(Commands.argument((String)"entity", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, (ResourceKey)Registries.ENTITY_TYPE)).suggests(SuggestionProviders.SUMMONABLE_ENTITIES).then(Commands.argument((String)"brain", (ArgumentType)ResourceLocationArgument.id()).executes(ctx -> SummonWithBrainCommand.spawnEntity((CommandSourceStack)ctx.getSource(), ResourceArgument.getSummonableEntityType((CommandContext)ctx, (String)"entity"), ResourceLocationArgument.getId((CommandContext)ctx, (String)"brain"), ((CommandSourceStack)ctx.getSource()).getPosition(), new CompoundTag()))));
    }

    private static int spawnEntity(CommandSourceStack source, Holder.Reference<EntityType<?>> type, ResourceLocation brainLocation, Vec3 pos, CompoundTag tag) throws CommandSyntaxException {
        Entity entity = SummonCommand.createEntity((CommandSourceStack)source, type, (Vec3)pos, (CompoundTag)tag, (boolean)true);
        if (!(entity instanceof DynamicBrainSupplantable)) {
            source.sendSuccess(() -> Component.literal((String)"Created entity, but it does not have a dynamic brain"), true);
            return 1;
        }
        DynamicBrainFactory dynamicBrainFactory = (DynamicBrainFactory)OccultEngineeringBrains.REGISTRY.get(brainLocation);
        if (dynamicBrainFactory == null) {
            source.sendSuccess(() -> Component.literal((String)("Created entity, but could not find brain " + brainLocation.toString())), true);
            return 1;
        }
        DynamicBrain<LivingEntity> brain = dynamicBrainFactory.create(entity);
        if (brain == null) {
            source.sendSuccess(() -> Component.literal((String)("Created entity, but the brain type " + brainLocation.toString() + " was invalid for this entity.")), true);
            return 1;
        }
        ((DynamicBrainSupplantable)entity).supplantBrain(brain);
        source.sendSuccess(() -> Component.translatable((String)"commands.summon.success", (Object[])new Object[]{entity.getDisplayName()}), true);
        return 1;
    }
}

