/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.networking.Message;
import com.klikli_dev.modonomicon.networking.SendAdvancementToClientMessage;
import com.klikli_dev.modonomicon.platform.Services;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class RequestAdvancementMessage
implements Message {
    public static final CustomPacketPayload.Type<RequestAdvancementMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"modonomicon", (String)"request_advancement"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RequestAdvancementMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, m -> m.advancementId, RequestAdvancementMessage::new);
    public ResourceLocation advancementId;

    public RequestAdvancementMessage(ResourceLocation advancementId) {
        this.advancementId = advancementId;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        AdvancementHolder adv = minecraftServer.getAdvancements().get(this.advancementId);
        if (adv != null) {
            Services.NETWORK.sendTo(player, new SendAdvancementToClientMessage(adv));
        } else {
            Modonomicon.LOG.warn("Requested Advancement {} from server, but not found", (Object)this.advancementId);
        }
    }
}

