/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world;

import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.AetherTimeAttachment;
import com.aetherteam.aether.world.WrappedGameRules;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.DerivedLevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;

public class AetherLevelData
extends DerivedLevelData {
    private final ServerLevel level;
    private final ServerLevelData wrapped;
    private final WrappedGameRules gameRules;
    private long dayTime;

    public AetherLevelData(ServerLevel level, WorldData worldData, ServerLevelData overworldData, long dayTime) {
        super(worldData, overworldData);
        this.level = level;
        this.wrapped = overworldData;
        this.gameRules = new WrappedGameRules(worldData.getGameRules(), (Set<GameRules.Key<GameRules.BooleanValue>>)ImmutableSet.of((Object)GameRules.RULE_WEATHER_CYCLE, (Object)GameRules.RULE_DOFIRETICK));
        this.dayTime = dayTime;
    }

    public long getOverworldDayTime() {
        return this.wrapped.getDayTime();
    }

    public long getDayTime() {
        if (((AetherTimeAttachment)this.level.getData(AetherDataAttachments.AETHER_TIME)).isTimeSynced()) {
            return this.wrapped.getDayTime();
        }
        return this.dayTime;
    }

    public void setDayTime(long time) {
        if (((AetherTimeAttachment)this.level.getData(AetherDataAttachments.AETHER_TIME)).isTimeSynced()) {
            this.wrapped.setDayTime(time);
        }
        this.dayTime = time;
    }

    public void setClearWeatherTime(int time) {
        this.wrapped.setClearWeatherTime(time);
    }

    public void setRaining(boolean raining) {
        this.wrapped.setRaining(raining);
    }

    public void setRainTime(int time) {
        this.wrapped.setRainTime(time);
    }

    public void setThundering(boolean thundering) {
        this.wrapped.setThundering(thundering);
    }

    public void setThunderTime(int time) {
        this.wrapped.setThunderTime(time);
    }

    public WrappedGameRules getGameRules() {
        return this.gameRules;
    }
}

