/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.gui.component.menu;

import com.aetherteam.aether.client.gui.screen.menu.AetherTitleScreen;
import com.aetherteam.aether.mixin.mixins.client.accessor.ButtonAccessor;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class AetherMenuButton
extends Button {
    private static final WidgetSprites AETHER_WIDGETS = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"title/button"), ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"title/button_highlighted"));
    private static final WidgetSprites AETHER_WIDGETS_SMALL = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"title/button"), ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"title/button_highlighted_small"));
    public final int originalX = this.getX();
    public final int originalY = this.getY();
    public int hoverOffset = 0;
    public int buttonCountOffset;
    public boolean serverButton;

    public AetherMenuButton(AetherTitleScreen screen, Button.Builder builder) {
        super(builder);
    }

    public AetherMenuButton(AetherTitleScreen screen, Button oldButton) {
        this(screen, new Button.Builder(oldButton.getMessage(), button -> oldButton.onPress()).bounds(oldButton.getX(), oldButton.getY(), oldButton.getWidth(), oldButton.getHeight()).createNarration(button -> ((ButtonAccessor)oldButton).callCreateNarrationMessage()));
        oldButton.visible = false;
        oldButton.active = false;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        ResourceLocation location = this.getWidth() < 100 ? AETHER_WIDGETS_SMALL.get(this.isActive(), this.isHoveredOrFocused()) : AETHER_WIDGETS.get(this.isActive(), this.isHoveredOrFocused());
        RenderSystem.enableBlend();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        guiGraphics.blitSprite(location, 200, 20, 0, 0, this.getX() + this.hoverOffset, this.getY(), 200, 20);
        RenderSystem.disableBlend();
        poseStack.pushPose();
        float textX = this.getX() + 35 + this.hoverOffset;
        float textY = (float)this.getY() + (float)(this.height - 8) / 2.0f;
        poseStack.translate(textX, textY, 0.0f);
        guiGraphics.drawString(font, this.getMessage(), 0, 0, this.getTextColor(mouseX, mouseY) | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
        poseStack.popPose();
    }

    public int getTextColor(int mouseX, int mouseY) {
        if (!this.serverButton) {
            return this.isMouseOver(mouseX, mouseY) ? 11842776 : 0xD4D4D4;
        }
        return this.isMouseOver(mouseX, mouseY) ? 13746759 : 15457113;
    }
}

