/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public interface MeltingBehavior {
    default public void tick(Block block, BlockState state, ServerLevel level, BlockPos pos, RandomSource random, IntegerProperty age) {
        if ((random.nextInt(3) == 0 || this.fewerNeigboursThan(block, (BlockGetter)level, pos, 4)) && this.slightlyMelt(state, (Level)level, pos, age)) {
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (Direction direction : Direction.values()) {
                mutablePos.setWithOffset((Vec3i)pos, direction);
                BlockState blockState = level.getBlockState((BlockPos)mutablePos);
                if (!blockState.is(block) || this.slightlyMelt(blockState, (Level)level, (BlockPos)mutablePos, age)) continue;
                level.scheduleTick((BlockPos)mutablePos, block, Mth.nextInt((RandomSource)random, (int)20, (int)40));
            }
        } else {
            level.scheduleTick(pos, block, Mth.nextInt((RandomSource)random, (int)20, (int)40));
        }
    }

    default public boolean fewerNeigboursThan(Block block, BlockGetter level, BlockPos pos, int neighborsRequired) {
        int i = 0;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            mutablePos.setWithOffset((Vec3i)pos, direction);
            if (!level.getBlockState((BlockPos)mutablePos).is(block) || ++i < neighborsRequired) continue;
            return false;
        }
        return true;
    }

    default public boolean slightlyMelt(BlockState state, Level level, BlockPos pos, IntegerProperty age) {
        int i = (Integer)state.getValue((Property)age);
        if (i < 3) {
            level.setBlock(pos, (BlockState)state.setValue((Property)age, (Comparable)Integer.valueOf(i + 1)), 2);
            return false;
        }
        this.melt(state, level, pos, age);
        return true;
    }

    public void melt(BlockState var1, Level var2, BlockPos var3, IntegerProperty var4);
}

