/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.block;

import com.aetherteam.aether.block.FreezingBehavior;
import com.aetherteam.aether.event.AetherEventDispatch;
import com.aetherteam.aether.event.FreezeEvent;
import com.aetherteam.aether.recipe.AetherRecipeTypes;
import com.aetherteam.aether.recipe.recipes.block.IcestoneFreezableRecipe;
import com.aetherteam.nitrogen.recipe.BlockPropertyPair;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;

public interface FreezingBlock
extends FreezingBehavior<BlockState> {
    public static final float SQRT_8 = Mth.sqrt((float)8.0f);
    public static final Table<Block, BlockPropertyPair, IcestoneFreezableRecipe> cachedBlocks = HashBasedTable.create();
    public static final List<Block> cachedResults = new ArrayList<Block>();

    @Override
    default public int freezeFromRecipe(Level level, BlockPos pos, BlockPos origin, BlockState source, int flag) {
        if (!level.isClientSide()) {
            BlockState oldBlockState = level.getBlockState(pos);
            Block oldBlock = oldBlockState.getBlock();
            FluidState fluidState = level.getFluidState(pos);
            if (fluidState.isEmpty() || oldBlockState.is(fluidState.createLegacyBlock().getBlock())) {
                IcestoneFreezableRecipe freezableRecipe;
                BlockPropertyPair pair = FreezingBlock.matchesCache(oldBlock, oldBlockState);
                if (pair != null && (freezableRecipe = (IcestoneFreezableRecipe)((Object)cachedBlocks.get((Object)oldBlock, (Object)pair))) != null) {
                    BlockState newBlockState = freezableRecipe.getResultState(oldBlockState);
                    Optional function = freezableRecipe.getFunction();
                    return this.freezeBlockAt(level, pos, origin, oldBlockState, newBlockState, function, source, flag);
                }
            } else if (!oldBlockState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                IcestoneFreezableRecipe freezableRecipe;
                oldBlockState = fluidState.createLegacyBlock();
                oldBlock = fluidState.createLegacyBlock().getBlock();
                BlockPropertyPair pair = FreezingBlock.matchesCache(oldBlock, oldBlockState);
                if (pair != null && (freezableRecipe = (IcestoneFreezableRecipe)((Object)cachedBlocks.get((Object)oldBlock, (Object)pair))) != null) {
                    level.destroyBlock(pos, true);
                    BlockState newBlockState = freezableRecipe.getResultState(oldBlockState);
                    Optional function = freezableRecipe.getFunction();
                    return this.freezeBlockAt(level, pos, origin, oldBlockState, newBlockState, function, source, flag);
                }
            }
        }
        return 0;
    }

    @Override
    default public FreezeEvent onFreeze(LevelAccessor level, BlockPos pos, BlockPos origin, BlockState oldBlockState, BlockState newBlockState, BlockState source) {
        return AetherEventDispatch.onBlockFreezeFluid(level, pos, origin, oldBlockState, newBlockState, source);
    }

    public static void cacheRecipes(Level level) {
        if (cachedBlocks.isEmpty()) {
            for (RecipeHolder recipe : level.getRecipeManager().getAllRecipesFor((RecipeType)AetherRecipeTypes.ICESTONE_FREEZABLE.get())) {
                IcestoneFreezableRecipe freezableRecipe = (IcestoneFreezableRecipe)recipe.value();
                BlockPropertyPair[] pairs = freezableRecipe.getIngredient().getPairs();
                if (pairs != null) {
                    Arrays.stream(pairs).forEach(pair -> cachedBlocks.put((Object)pair.block(), pair, (Object)freezableRecipe));
                }
                cachedResults.add(freezableRecipe.getResult().block());
            }
        }
    }

    @Nullable
    public static BlockPropertyPair matchesCache(Block block, BlockState blockState) {
        if (cachedBlocks.containsRow((Object)block)) {
            BlockPropertyPair pair = null;
            for (Map.Entry entry : cachedBlocks.row((Object)block).entrySet()) {
                if (!((BlockPropertyPair)entry.getKey()).matches(blockState)) continue;
                pair = (BlockPropertyPair)entry.getKey();
            }
            return pair;
        }
        return null;
    }
}

