/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.items;

import earth.terrarium.tempad.api.context.InventoryContext;
import earth.terrarium.tempad.api.context.SyncableContext;
import earth.terrarium.tempad.api.locations.IndirectLocation;
import earth.terrarium.tempad.api.locations.LocationGetter;
import earth.terrarium.tempad.api.locations.NamedGlobalVec3;
import earth.terrarium.tempad.api.tva_device.ChrononHandler;
import earth.terrarium.tempad.api.tva_device.ChrononHandlerKt;
import earth.terrarium.tempad.api.tva_device.UpgradeHandler;
import earth.terrarium.tempad.api.tva_device.UpgradeHandlerKt;
import earth.terrarium.tempad.client.tooltip.ChrononToolipKt;
import earth.terrarium.tempad.common.block.RudimentaryTempadBE;
import earth.terrarium.tempad.common.entity.TimedoorEntity;
import earth.terrarium.tempad.common.registries.ModAttachmentsKt;
import earth.terrarium.tempad.common.registries.ModBlocks;
import earth.terrarium.tempad.common.registries.ModComponentsKt;
import earth.terrarium.tempad.common.registries.ModItems;
import earth.terrarium.tempad.common.utils.ExtensionsKt;
import earth.terrarium.tempad.common.utils.ItemStackBuilderKt;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentHolder;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\u00020\u0012*\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\t\u001a\u00020\nJ(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\nH\u0016J2\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J8\u0010 \u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#H\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J \u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u0015H\u0016\u00a8\u0006+"}, d2={"Learth/terrarium/tempad/common/items/RudimentaryTempadItem;", "Lnet/minecraft/world/item/BlockItem;", "<init>", "()V", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "openTimedoor", "", "Learth/terrarium/tempad/api/context/SyncableContext;", "overrideStackedOnOther", "", "stack", "slot", "Lnet/minecraft/world/inventory/Slot;", "action", "Lnet/minecraft/world/inventory/ClickAction;", "updateCustomBlockEntityTag", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "overrideOtherStackedOnMe", "other", "access", "Lnet/minecraft/world/entity/SlotAccess;", "getTooltipImage", "Ljava/util/Optional;", "Lnet/minecraft/world/inventory/tooltip/TooltipComponent;", "shouldCauseReequipAnimation", "oldStack", "newStack", "slotChanged", "tempad-1.21.1"})
@SourceDebugExtension(value={"SMAP\nRudimentaryTempadItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RudimentaryTempadItem.kt\nearth/terrarium/tempad/common/items/RudimentaryTempadItem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1#2:116\n*E\n"})
public final class RudimentaryTempadItem
extends BlockItem {
    public RudimentaryTempadItem() {
        super((Block)ModBlocks.INSTANCE.getTimedoorProjector(), new Item.Properties().stacksTo(1));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        if (level.isClientSide) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
            return interactionResultHolder;
        }
        this.openTimedoor(ExtensionsKt.ctx(player, ExtensionsKt.getSlot(usedHand, player)), player);
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
        return interactionResultHolder;
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Player player = context.getPlayer();
            boolean bl = player != null ? player.isShiftKeyDown() : false;
            if (bl) {
                InteractionResult interactionResult = super.useOn(context);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useOn(...)");
                return interactionResult;
            }
            Player player2 = context.getPlayer();
            if (player2 == null) {
                return InteractionResult.PASS;
            }
            Player player3 = player2;
            InventoryContext inventoryContext = ExtensionsKt.getSyncableCtx(context);
            if (inventoryContext == null) break block2;
            this.openTimedoor(inventoryContext, player3);
        }
        return InteractionResult.PASS;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void openTimedoor(@NotNull SyncableContext<?> $this$openTimedoor, @NotNull Player player) {
        Intrinsics.checkNotNullParameter($this$openTimedoor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        LocationGetter portalTarget = ModComponentsKt.getPortalTarget((MutableDataComponentHolder)$this$openTimedoor.getStack());
        Object object = portalTarget;
        if (object != null) {
            UpgradeHandler upgradeHandler = UpgradeHandlerKt.getUpgrades($this$openTimedoor.getStack());
            Intrinsics.checkNotNull((Object)upgradeHandler);
            ChrononHandler chrononHandler = ChrononHandlerKt.getChronons($this$openTimedoor.getStack());
            Intrinsics.checkNotNull((Object)chrononHandler);
            if ((object = object.get(upgradeHandler, chrononHandler)) != null) {
                Object pos = object;
                boolean bl = false;
                if (player.level().isClientSide) return;
                IndirectLocation it = portalTarget instanceof IndirectLocation ? (IndirectLocation)portalTarget : null;
                boolean bl2 = false;
                IndirectLocation indirectLocation = it;
                IndirectLocation indirectLocation2 = it;
                Pair pair = TuplesKt.to((Object)(indirectLocation != null ? indirectLocation.getProvider() : null), (Object)(indirectLocation2 != null ? indirectLocation2.getId() : null));
                ResourceLocation provider = (ResourceLocation)pair.component1();
                UUID id = (UUID)pair.component2();
                TimedoorEntity.Companion.openTimedoor(player, $this$openTimedoor, provider, id, (NamedGlobalVec3)pos, (Function1<? super TimedoorEntity, Unit>)((Function1)RudimentaryTempadItem::openTimedoor$lambda$2$lambda$1));
                return;
            }
        }
        Function0 cfr_ignored_0 = () -> RudimentaryTempadItem.openTimedoor$lambda$3(player);
    }

    public boolean overrideStackedOnOther(@NotNull ItemStack stack, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        if (ModComponentsKt.getPortalTarget((MutableDataComponentHolder)stack) != null) {
            if (slot.hasItem()) {
                return false;
            }
            ExtensionsKt.setContents(slot, ItemStackBuilderKt.stack$default(ModItems.INSTANCE.getLocationCard(), 0, arg_0 -> RudimentaryTempadItem.overrideStackedOnOther$lambda$4(stack, arg_0), 1, null));
            ModComponentsKt.setPortalTarget((MutableDataComponentHolder)stack, null);
            return true;
        }
        if (ExtensionsKt.getContents(slot).getItem() == ModItems.INSTANCE.getLocationCard()) {
            ItemStack itemStack = ExtensionsKt.getContents(slot);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"<get-contents>(...)");
            if (ModComponentsKt.getPortalTarget((MutableDataComponentHolder)itemStack) != null) {
                MutableDataComponentHolder mutableDataComponentHolder = (MutableDataComponentHolder)stack;
                ItemStack itemStack2 = ExtensionsKt.getContents(slot);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"<get-contents>(...)");
                ModComponentsKt.setPortalTarget(mutableDataComponentHolder, ModComponentsKt.getPortalTarget((MutableDataComponentHolder)itemStack2));
                ItemStack itemStack3 = ExtensionsKt.getContents(slot);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"<get-contents>(...)");
                ExtensionsKt.setContents(slot, ExtensionsKt.minus(itemStack3, 1));
                return true;
            }
        }
        return false;
    }

    protected boolean updateCustomBlockEntityTag(@NotNull BlockPos pos, @NotNull Level level, @Nullable Player player, @NotNull ItemStack stack, @NotNull BlockState state) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity == null) break block3;
            BlockEntity blockEntity2 = blockEntity;
            boolean bl = false;
            if (blockEntity2 instanceof RudimentaryTempadBE) {
                LocationGetter locationGetter = ModComponentsKt.getPortalTarget((MutableDataComponentHolder)stack);
                if (locationGetter != null) {
                    LocationGetter it = locationGetter;
                    boolean bl2 = false;
                    ((RudimentaryTempadBE)blockEntity2).setPortalTarget(it);
                }
                Player player2 = player;
                if (player2 != null) {
                    Player it = player2;
                    boolean bl3 = false;
                    ModAttachmentsKt.setOwner((AttachmentHolder)blockEntity2, it.getGameProfile());
                }
                ((RudimentaryTempadBE)blockEntity2).setChrononContent(ModComponentsKt.getChrononContent((MutableDataComponentHolder)stack));
            }
        }
        return super.updateCustomBlockEntityTag(pos, level, player, stack, state);
    }

    public boolean overrideOtherStackedOnMe(@NotNull ItemStack stack, @NotNull ItemStack other, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        if (ModComponentsKt.getPortalTarget((MutableDataComponentHolder)stack) == null && other.getItem() == ModItems.INSTANCE.getLocationCard() && ModComponentsKt.getPortalTarget((MutableDataComponentHolder)other) != null) {
            ModComponentsKt.setPortalTarget((MutableDataComponentHolder)stack, ModComponentsKt.getPortalTarget((MutableDataComponentHolder)other));
            access.set(ExtensionsKt.minus(other, 1));
            return true;
        }
        return false;
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        ChrononHandler chrononHandler = ChrononHandlerKt.getChronons(stack);
        Optional<TooltipComponent> optional = Optional.ofNullable(chrononHandler != null ? ChrononToolipKt.getTooltip(chrononHandler) : null);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    public boolean shouldCauseReequipAnimation(@NotNull ItemStack oldStack, @NotNull ItemStack newStack, boolean slotChanged) {
        Intrinsics.checkNotNullParameter((Object)oldStack, (String)"oldStack");
        Intrinsics.checkNotNullParameter((Object)newStack, (String)"newStack");
        return false;
    }

    private static final Unit openTimedoor$lambda$2$lambda$1(TimedoorEntity it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        it.setGlitching(true);
        return Unit.INSTANCE;
    }

    private static final Unit openTimedoor$lambda$3(Player $player) {
        if (!$player.level().isClientSide) {
            $player.displayClientMessage((Component)TimedoorEntity.Companion.getPosFail(), true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit overrideStackedOnOther$lambda$4(ItemStack $stack, ItemStack $this$stack) {
        Intrinsics.checkNotNullParameter((Object)$this$stack, (String)"$this$stack");
        ModComponentsKt.setPortalTarget((MutableDataComponentHolder)$this$stack, ModComponentsKt.getPortalTarget((MutableDataComponentHolder)$stack));
        return Unit.INSTANCE;
    }
}

