/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.data;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.neoforged.neoforge.network.connection.ConnectionType;
import org.jetbrains.annotations.Nullable;

public class MCDataByteBuf
implements MCDataInput,
MCDataOutput {
    protected final ByteBuf buf;
    @Nullable
    protected final RegistryAccess registryAccess;

    public MCDataByteBuf() {
        this(Unpooled.buffer(), null);
    }

    public MCDataByteBuf(@Nullable RegistryAccess registryAccess) {
        this(Unpooled.buffer(), registryAccess);
    }

    public MCDataByteBuf(ByteBuf buf) {
        this(buf, null);
    }

    public MCDataByteBuf(ByteBuf buf, @Nullable RegistryAccess registryAccess) {
        this.buf = buf;
        if (registryAccess == null && buf instanceof RegistryFriendlyByteBuf) {
            RegistryFriendlyByteBuf rBuf = (RegistryFriendlyByteBuf)buf;
            registryAccess = rBuf.registryAccess();
        }
        this.registryAccess = registryAccess;
    }

    public FriendlyByteBuf toFriendlyByteBuf() {
        return this.buf instanceof FriendlyByteBuf ? (FriendlyByteBuf)this.buf : new FriendlyByteBuf(this.buf);
    }

    public RegistryFriendlyByteBuf toRegistryFriendlyByteBuf() {
        ByteBuf byteBuf = this.buf;
        if (byteBuf instanceof RegistryFriendlyByteBuf) {
            RegistryFriendlyByteBuf rBuf = (RegistryFriendlyByteBuf)byteBuf;
            return rBuf;
        }
        if (this.registryAccess == null) {
            throw new RuntimeException("RegistryAccess required for this operation.");
        }
        return new RegistryFriendlyByteBuf(this.buf, this.registryAccess, ConnectionType.NEOFORGE);
    }

    public Tag toTag() {
        return new ByteArrayTag(this.buf.array());
    }

    public static MCDataByteBuf fromTag(Tag tag, RegistryAccess registries) {
        if (!(tag instanceof ByteArrayTag)) {
            throw new IllegalArgumentException("Expected ByteArrayNBT, got: " + tag.getClass().getSimpleName());
        }
        return new MCDataByteBuf(Unpooled.copiedBuffer((byte[])((ByteArrayTag)tag).getAsByteArray()), registries);
    }

    public CompoundTag writeToNBT(CompoundTag tag, String key) {
        tag.put(key, this.toTag());
        return tag;
    }

    public static MCDataByteBuf readFromNBT(CompoundTag tag, String key, RegistryAccess registries) {
        return MCDataByteBuf.fromTag(tag.get(key), registries);
    }

    @Override
    public <T> MCDataOutput writeWithCodec(StreamEncoder<? super FriendlyByteBuf, T> codec, T thing) {
        codec.encode((Object)this.toFriendlyByteBuf(), thing);
        return this;
    }

    @Override
    public <T> MCDataOutput writeWithRegistryCodec(StreamEncoder<? super RegistryFriendlyByteBuf, T> codec, T thing) {
        codec.encode((Object)this.toRegistryFriendlyByteBuf(), thing);
        return this;
    }

    @Override
    public <T> T readWithCodec(StreamDecoder<? super FriendlyByteBuf, T> codec) {
        return (T)codec.decode((Object)this.toFriendlyByteBuf());
    }

    @Override
    public <T> T readWithRegistryCodec(StreamDecoder<? super RegistryFriendlyByteBuf, T> codec) {
        return (T)codec.decode((Object)this.toRegistryFriendlyByteBuf());
    }

    @Override
    public byte readByte() {
        return this.buf.readByte();
    }

    @Override
    public short readUByte() {
        return this.buf.readUnsignedByte();
    }

    @Override
    public char readChar() {
        return this.buf.readChar();
    }

    @Override
    public short readShort() {
        return this.buf.readShort();
    }

    @Override
    public int readUShort() {
        return this.buf.readUnsignedShort();
    }

    @Override
    public int readInt() {
        return this.buf.readInt();
    }

    @Override
    public long readLong() {
        return this.buf.readLong();
    }

    @Override
    public float readFloat() {
        return this.buf.readFloat();
    }

    @Override
    public double readDouble() {
        return this.buf.readDouble();
    }

    @Override
    public boolean readBoolean() {
        return this.buf.readBoolean();
    }

    @Override
    public MCDataOutput writeByte(int b) {
        this.buf.writeByte(b);
        return this;
    }

    @Override
    public MCDataOutput writeChar(int c) {
        this.buf.writeChar(c);
        return this;
    }

    @Override
    public MCDataOutput writeShort(int s) {
        this.buf.writeShort(s);
        return this;
    }

    @Override
    public MCDataOutput writeInt(int i) {
        this.buf.writeInt(i);
        return this;
    }

    @Override
    public MCDataOutput writeLong(long l) {
        this.buf.writeLong(l);
        return this;
    }

    @Override
    public MCDataOutput writeFloat(float f) {
        this.buf.writeFloat(f);
        return this;
    }

    @Override
    public MCDataOutput writeDouble(double d) {
        this.buf.writeDouble(d);
        return this;
    }

    @Override
    public MCDataOutput writeBoolean(boolean b) {
        this.buf.writeBoolean(b);
        return this;
    }
}

