/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.net;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.MainThreaded;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.net.PacketContext;
import org.zeith.solarflux.init.SolarPanelsSF;
import org.zeith.solarflux.panels.SolarPanel;

@MainThreaded
public class PacketSyncPanelData
implements IPacket {
    private String name;
    private SolarPanel.SolarPanelData data;

    public PacketSyncPanelData(String name, SolarPanel.SolarPanelData data) {
        this.name = name;
        this.data = data;
    }

    public PacketSyncPanelData() {
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeUtf(this.name);
        this.data.write(buf);
    }

    public void read(FriendlyByteBuf buf) {
        this.name = buf.readUtf();
        this.data = new SolarPanel.SolarPanelData(buf);
    }

    public SolarPanel.SolarPanelData getData() {
        return this.data;
    }

    public void clientExecute(PacketContext ctx) {
        SolarPanel sp = SolarPanelsSF.PANELS.get(this.name);
        if (sp != null) {
            sp.handle(this);
        }
    }

    public static void sendAllPanels(ServerPlayer mp) {
        SolarPanelsSF.listPanels().forEach(i -> Network.sendTo((IPacket)new PacketSyncPanelData(i.name, i.getDelegateData()), (ServerPlayer)mp));
    }
}

