/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.items.upgrades._base;

import com.google.common.base.Suppliers;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import org.zeith.hammerlib.api.inv.SimpleInventory;
import org.zeith.hammerlib.compat.base.Ability;
import org.zeith.solarflux.SolarFlux;
import org.zeith.solarflux.api.ISolarPanelTile;

public abstract class UpgradeItem
extends Item {
    protected Supplier<String> tooltipId;

    public UpgradeItem(int stackSize) {
        super(new Item.Properties().stacksTo(stackSize));
        SolarFlux.ITEM_GROUP.add((ItemLike)this);
        this.tooltipId = Suppliers.memoize(() -> Util.makeDescriptionId((String)"info", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
    }

    public UpgradeItem(Item.Properties props) {
        super(props);
        SolarFlux.ITEM_GROUP.add((ItemLike)this);
        this.tooltipId = Suppliers.memoize(() -> Util.makeDescriptionId((String)"info", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
    }

    public void update(ISolarPanelTile tile, ItemStack stack, int amount) {
    }

    public void onInstalled(ISolarPanelTile tile, int prevCount, int newCount) {
    }

    public void onRemoved(ISolarPanelTile tile, int prevCount, int newCount) {
    }

    protected Object[] hoverTextData(ItemStack stack) {
        return new Object[0];
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> tooltip, TooltipFlag context) {
        try {
            MutableComponent txt = Component.literal((String)Component.translatable((String)this.tooltipId.get()).getString().formatted(this.hoverTextData(stack)));
            tooltip.add((Component)txt.withStyle(Style.EMPTY.withColor(0x666666)));
        }
        catch (IllegalFormatException e) {
            tooltip.add((Component)Component.translatable((String)e.getMessage()));
        }
    }

    public boolean canStayInPanel(ISolarPanelTile tile, ItemStack stack, SimpleInventory upgradeInv) {
        return true;
    }

    public boolean canInstall(ISolarPanelTile tile, ItemStack stack, SimpleInventory upgradeInv) {
        return true;
    }

    public int getMaxUpgradesInstalled(ISolarPanelTile tile) {
        return this.getMaxStackSize(this.getDefaultInstance());
    }

    public <T> Optional<T> findAbility(Ability<T> ability) {
        return ability.findIn(new Object[0]);
    }
}

