/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.items.upgrades;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.zeith.solarflux.api.ISolarPanelTile;
import org.zeith.solarflux.init.SolarPanelsSF;
import org.zeith.solarflux.items.upgrades._base.UpgradeItem;
import org.zeith.solarflux.util.BlockPosFace;

public class ItemTraversalUpgrade
extends UpgradeItem {
    static List<BlockPos> cache = new ArrayList<BlockPos>();
    private static final Direction[] DIRECTIONS = Direction.values();

    public ItemTraversalUpgrade() {
        super(1);
    }

    @Override
    public void update(ISolarPanelTile tile, ItemStack stack, int amount) {
        if (tile.level().getDayTime() % 20L == 0L) {
            cache.clear();
            tile.traversal().clear();
            cache.add(tile.pos());
            ItemTraversalUpgrade.findMachines(tile, cache, tile.traversal());
        }
    }

    public static void findMachines(ISolarPanelTile tile, List<BlockPos> cache, List<BlockPosFace> acceptors) {
        for (int i = 0; i < cache.size(); ++i) {
            BlockPos pos = cache.get(i);
            for (Direction face : DIRECTIONS) {
                IEnergyStorage e;
                BlockPos p = pos.relative(face);
                if (p.distSqr((Vec3i)cache.get(0)) > (double)SolarPanelsSF.TRAVERSAL_UPGRADE_RANGE || (e = (IEnergyStorage)tile.level().getCapability(Capabilities.EnergyStorage.BLOCK, p, (Object)face.getOpposite())) == null || !e.canReceive() || cache.contains(p)) continue;
                cache.add(p);
                BlockPosFace bpf = new BlockPosFace(p, face.getOpposite());
                acceptors.add(bpf);
            }
        }
    }

    @Override
    protected Object[] hoverTextData(ItemStack stack) {
        return new Object[]{Math.round((float)Math.sqrt(SolarPanelsSF.TRAVERSAL_UPGRADE_RANGE))};
    }
}

