/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.items.upgrades;

import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.zeith.solarflux.api.IFurnaceBlockEntity;
import org.zeith.solarflux.api.ISolarPanelTile;
import org.zeith.solarflux.items.upgrades._base.UpgradeItem;
import org.zeith.solarflux.util.BlockPosFace;

public class ItemFurnaceUpgrade
extends UpgradeItem {
    public ItemFurnaceUpgrade() {
        super(1);
    }

    @Override
    public void update(ISolarPanelTile tile, ItemStack stack, int amount) {
        Level lvl = tile.level();
        HashSet<BlockPos> updated = new HashSet<BlockPos>();
        for (Direction d : Direction.values()) {
            BlockPos pos = tile.pos().relative(d.getOpposite());
            if (!this.updateFurnaceAt(tile, lvl, pos, d)) continue;
            updated.add(pos);
        }
        for (BlockPosFace face : tile.traversal()) {
            if (!updated.add(face.pos)) continue;
            this.updateFurnaceAt(tile, lvl, face.pos, face.face);
        }
    }

    public boolean updateFurnaceAt(ISolarPanelTile solar, Level lvl, BlockPos pos, Direction dir) {
        IFurnaceBlockEntity fbe;
        BlockEntity blockEntity = lvl.getBlockEntity(pos);
        return blockEntity instanceof IFurnaceBlockEntity && (fbe = (IFurnaceBlockEntity)blockEntity).getSideForSolarPanel() == dir && fbe.activateWithSolarPanel(solar);
    }
}

