/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.items;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import org.zeith.solarflux.SolarFlux;

public class JSItem
extends Item {
    final ResourceLocation registryName;
    LanguageData langs;

    public JSItem(ResourceLocation registryName, Item.Properties properties, LanguageData langs) {
        super(properties);
        this.registryName = registryName;
        this.langs = langs;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public boolean hasLang() {
        return this.langs != null;
    }

    public LanguageData getLang() {
        return this.langs;
    }

    public static class LanguageData {
        public final Map<String, String> langToName = new HashMap<String, String>();
        public String def;
        final FutureJSGenerator material;

        public LanguageData(FutureJSGenerator material) {
            this.material = material;
        }

        public LanguageData put(String lang, String loc) {
            if ((lang = lang.toLowerCase()).equalsIgnoreCase("en_us")) {
                this.def = loc;
            }
            this.langToName.put(lang, loc);
            return this;
        }

        public String getName(String lang) {
            return this.langToName.getOrDefault(lang, this.def);
        }

        public ItemLike build() {
            if (this.def == null) {
                throw new RuntimeException("Unable to apply languages: no 'en_us' value found!");
            }
            this.material.langs = this;
            return this.material;
        }
    }

    public static class FutureJSGenerator
    implements ItemLike {
        public final String name;
        private JSItem item;
        private LanguageData langs;

        public FutureJSGenerator(String name) {
            this.name = name;
        }

        public LanguageData langBuilder() {
            return new LanguageData(this);
        }

        public JSItem create() {
            if (this.item != null) {
                return this.item;
            }
            this.item = (JSItem)SolarFlux.ITEM_GROUP.add((ItemLike)new JSItem(SolarFlux.id(this.name), new Item.Properties(), this.langs));
            return this.item;
        }

        public Item asItem() {
            return this.item;
        }
    }
}

