/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.container;

import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import org.zeith.solarflux.block.SolarPanelTile;
import org.zeith.solarflux.items.upgrades._base.UpgradeItem;

public class SlotUpgrade
extends SlotItemHandler {
    SolarPanelTile tile;

    public SlotUpgrade(SolarPanelTile inventoryIn, int index, int xPosition, int yPosition) {
        super((IItemHandler)inventoryIn.upgradeInventory, index, xPosition, yPosition);
        this.tile = inventoryIn;
    }

    public int getMaxStackSize(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof UpgradeItem)) {
            return 0;
        }
        UpgradeItem ui = (UpgradeItem)item;
        ItemStack current = this.getItem();
        if (!current.isEmpty() && !current.is((Item)ui) || !this.tile.upgradeInventory.isItemValid(this.getSlotIndex(), stack)) {
            return 0;
        }
        return ui.getMaxUpgradesInstalled(this.tile) - this.tile.getUpgrades(ui) + current.getCount();
    }

    @NotNull
    public ItemStack remove(int amount) {
        ItemStack it = this.getItem();
        Item item = it.getItem();
        if (item instanceof UpgradeItem) {
            UpgradeItem up = (UpgradeItem)item;
            int prevCount = this.tile.getUpgrades(up);
            ItemStack it0 = super.remove(amount);
            int updCount = this.tile.getUpgrades(up);
            up.onRemoved(this.tile, prevCount, updCount);
            return it0;
        }
        return super.remove(amount);
    }

    public ItemStack safeInsert(ItemStack item, int amount) {
        Item item2 = item.getItem();
        if (item2 instanceof UpgradeItem) {
            UpgradeItem up = (UpgradeItem)item2;
            int prev = this.tile.getUpgrades(up);
            if (!item.isEmpty() && this.mayPlace(item)) {
                ItemStack itemstack = this.getItem();
                int insert = Math.min(Math.min(amount, item.getCount()), this.getMaxStackSize(item) - itemstack.getCount());
                insert = Math.min(insert, up.getMaxUpgradesInstalled(this.tile) - prev);
                insert = Math.max(0, insert);
                if (itemstack.isEmpty()) {
                    this.set(item.split(insert));
                } else if (ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)item)) {
                    item.shrink(insert);
                    itemstack.grow(insert);
                    this.set(itemstack);
                }
                if (insert > 0) {
                    int cur = this.tile.getUpgrades(up);
                    up.onInstalled(this.tile, prev, cur);
                }
                return item;
            }
            return item;
        }
        return super.safeInsert(item, amount);
    }

    public boolean mayPlace(ItemStack stack) {
        UpgradeItem ui;
        Item item;
        return this.tile.upgradeInventory.isItemValid(this.getSlotIndex(), stack) && (item = stack.getItem()) instanceof UpgradeItem && this.tile.getUpgrades(ui = (UpgradeItem)item) < ui.getMaxUpgradesInstalled(this.tile);
    }
}

